/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.invocationcallback;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 8164327856558890177L;
    private static final int WAIT_SECONDS = 5;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void completedTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = new AtomicInteger(0);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        InvocationCallback<String> callback = JAXRSClientIT.createCallback(ai, countDownLatch);
        Invocation.Builder builder = JAXRSClientIT.createInvocationBuilder();
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        try {
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            JAXRSClientIT.fault(e);
        }
        JAXRSClientIT.assertContains(future, "get");
        JAXRSClientIT.assertEqualsInt(10, ai.get(), "Unexpected result from InvocationCallback", ai.get(), "expected was 10");
        JAXRSClientIT.logMsg("InvocationCallback#completed has been called as expected");
    }

    @Test
    public void failedTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = new AtomicInteger(0);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        InvocationCallback<String> callback = JAXRSClientIT.createCallback(ai, countDownLatch);
        Invocation.Builder builder = JAXRSClientIT.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        try {
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            JAXRSClientIT.fault(e);
        }
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        JAXRSClientIT.assertEqualsInt(100, ai.get(), "Unexpected result from InvocationCallback", ai.get(), "expected was 100");
        JAXRSClientIT.logMsg("InvocationCallback#failed has been called as expected");
    }

    private static ClientRequestFilter createRequestFilter() {
        ClientRequestFilter filter = new ClientRequestFilter(){

            public void filter(ClientRequestContext ctx) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append(ctx.getMethod()).append(";");
                if (ctx.hasEntity()) {
                    sb.append(ctx.getEntity()).append(";");
                }
                Response r = Response.ok((Object)sb.toString()).build();
                ctx.abortWith(r);
            }
        };
        return filter;
    }

    private static Invocation.Builder createInvocationBuilder(ClientRequestFilter filter) {
        Client client = ClientBuilder.newClient();
        if (filter != null) {
            client.register((Object)filter);
        }
        WebTarget target = client.target("http://cts.tck:888");
        Invocation.Builder builder = target.request();
        return builder;
    }

    private static Invocation.Builder createInvocationBuilder() {
        return JAXRSClientIT.createInvocationBuilder(JAXRSClientIT.createRequestFilter());
    }

    private static InvocationCallback<String> createCallback(final AtomicInteger ai, final CountDownLatch latch) {
        InvocationCallback<String> callback = null;
        callback = new InvocationCallback<String>(){

            public void completed(String arg0) {
                ai.set(ai.get() + 10);
                latch.countDown();
            }

            public void failed(Throwable throwable) {
                ai.set(ai.get() + 100);
                latch.countDown();
            }
        };
        return callback;
    }

    private static void assertContains(String responseEntity, String what) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)responseEntity.toLowerCase().contains(what.toLowerCase()), (String)(responseEntity + " does not contain expected " + what));
        JAXRSClientIT.logMsg("Found expected", what);
    }

    private static void assertContains(Future<String> future, String what) throws JAXRSCommonClient.Fault {
        String responseEntity = null;
        try {
            responseEntity = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        JAXRSClientIT.assertContains(responseEntity, what);
    }

    private void assertExceptionWithProcessingExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertProcessingExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    private void assertProcessingExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        Assertions.assertTrue((boolean)JAXRSClientIT.hasWrapped(e, ProcessingException.class), (String)("ExecutionException wrapped " + e.getCause() + " rather then ProcessingException"));
        JAXRSClientIT.logMsg("ExecutionException.getCause is ProcessingException as expected");
    }

    private static boolean hasWrapped(Throwable parent, Class<? extends Throwable> wrapped) {
        while (parent.getCause() != null) {
            if (wrapped.isInstance(parent.getCause())) {
                return true;
            }
            parent = parent.getCause();
        }
        return false;
    }
}

