/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.head;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import ee.jakarta.tck.ws.rs.ee.rs.head.HttpMethodHeadTest;
import ee.jakarta.tck.ws.rs.ee.rs.head.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_head_web/HeadTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/head/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_head_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HttpMethodHeadTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void headTest1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/plain");
        this.setProperty("REQUEST", this.buildRequest("HEAD", ""));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: text-plain");
        this.invoke();
    }

    @Test
    public void headTest2() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/html");
        this.setProperty("REQUEST", this.buildRequest("HEAD", ""));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: text-html");
        this.invoke();
    }

    @Test
    public void headSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("HEAD", "sub"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD:  sub-text-html");
        this.invoke();
    }

    @Test
    public void headGetTest() throws JAXRSCommonClient.Fault, IOException {
        this.setProperty("REQUEST", this.buildRequest("HEAD", "get"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: get");
        this.invoke();
        HttpResponse request = this._testCase.getResponse();
        Assertions.assertTrue((request.getResponseBodyAsRawString() == null ? 1 : 0) != 0, (String)"Unexpected entity in request body");
    }
}

