/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.application;

import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationHolderSingleton;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.TSAppConfig;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Set;

@Path(value="ApplicationTest")
public class ApplicationServlet {
    @GET
    @Path(value="/GetSingletons")
    public Response testGetSingletons(@Context Application application) {
        if (application.getSingletons() == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return Response.ok((Object)String.valueOf(application.getSingletons().size())).build();
    }

    @GET
    @Path(value="/GetClasses")
    public Response testGetClasses(@Context Application application) {
        if (!(application = ApplicationServlet.getDeproxiedApplication(application)).getClasses().contains(ApplicationServlet.class)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return Response.ok((Object)String.valueOf(application.getClasses().size())).build();
    }

    @Path(value="properties")
    @GET
    public Response getProperties(@Context Application application) {
        Response response = null;
        Map properties = (application = ApplicationServlet.getDeproxiedApplication(application)).getProperties();
        if (properties == null || properties.size() == 0) {
            response = Response.noContent().build();
        } else {
            Object val0 = properties.get(TSAppConfig.KEYS[0]);
            Object val1 = properties.get(TSAppConfig.KEYS[1]);
            response = TSAppConfig.VALUES[0].equals(val0) && TSAppConfig.VALUES[1].equals(val1) ? Response.ok((Object)JaxrsUtil.mapToString(properties)).build() : Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return response;
    }

    protected static Application getDeproxiedApplication(Application application) {
        Set singletons = application.getSingletons();
        for (Object s : singletons) {
            if (s.getClass() != ApplicationHolderSingleton.class) continue;
            return ((ApplicationHolderSingleton)s).getApplication();
        }
        throw new IllegalStateException("ApplicationHolderSingleton has not been found in a list of singletons");
    }
}

