/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standardwithxmlbinding;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.standardwithxmlbinding.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.standardwithxmlbinding.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_standardwithxmlbinding_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        String ct = JAXRSClientIT.buildContentType(md);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        if (!MediaType.WILDCARD_TYPE.equals((Object)md)) {
            this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, ct);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(md));
        this.invoke();
    }

    private void setPropertyAndInvokeXml(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "<tag>" + resourceMethod + "</tag>");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, resourceMethod);
        this.setPropertyAndInvoke(resourceMethod, md);
    }

    private void setPropertyAndInvokeXml(String method) throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvokeXml(method, MediaType.TEXT_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_ATOM_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_SVG_XML_TYPE);
        this.setPropertyAndInvokeXml(method, new MediaType("application", "*+xml"));
    }

    @Override
    protected String getAbsoluteUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this._hostname).append(":").append(this._port).append(this.getContextRoot());
        return sb.toString();
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/standardwithxmlbinding/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_standardwithxmlbinding_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbElementProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvokeXml("jaxb");
    }
}

