/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource;

import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.OutboundSSEEventImpl;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;

@Path(value="su")
public class ServiceUnavailableResource {
    private static volatile Boolean isServiceUnavailable = false;
    private static volatile int isConnectionLost = 0;
    private static volatile int retry = 1;
    private static int count = 0;
    static final String MESSAGE = "some_ServiceUnavailableEndpoint_message";

    @GET
    @Path(value="reset")
    public String reset() {
        retry = 0;
        isServiceUnavailable = false;
        isConnectionLost = 0;
        count = 0;
        return "RESET";
    }

    @GET
    @Path(value="count")
    public int count() {
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="available")
    @Produces(value={"text/plain"})
    public String setUnavailable() {
        Boolean bl = isServiceUnavailable;
        synchronized (bl) {
            isServiceUnavailable = true;
            retry = 1;
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="lost")
    @Produces(value={"text/plain"})
    public int setConnectionLost(int count) {
        Boolean bl = isServiceUnavailable;
        synchronized (bl) {
            isConnectionLost = count;
            isServiceUnavailable = false;
            retry = 1;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="retry")
    @Produces(value={"text/plain"})
    public int retry(int seconds) {
        Boolean bl = isServiceUnavailable;
        synchronized (bl) {
            retry = seconds;
        }
        return seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="sse")
    @Produces(value={"text/event-stream"})
    public void sendMessage(@Context SseEventSink sink, @Context Sse sse) {
        Boolean bl = isServiceUnavailable;
        synchronized (bl) {
            if (isServiceUnavailable.booleanValue()) {
                isServiceUnavailable = false;
                throw new WebApplicationException(Response.status((int)503).header("Retry-After", (Object)String.valueOf(retry)).build());
            }
            try (SseEventSink s = sink;){
                s.send(sse.newEvent(MESSAGE));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="sselost")
    @Produces(value={"text/event-stream"})
    public void sseLost(@Context SseEventSink sink, @Context Sse sse) {
        Boolean bl = isServiceUnavailable;
        synchronized (bl) {
            ++count;
            if (isConnectionLost != 0) {
                --isConnectionLost;
                sink.close();
            } else {
                try (SseEventSink s = sink;){
                    s.send(sse.newEvent(MESSAGE));
                }
            }
        }
    }

    @GET
    @Path(value="reconnectdelay")
    @Produces(value={"text/event-stream"})
    public void sendRetry(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)MESSAGE).reconnectDelay(3000L).build());
        }
    }

    @GET
    @Path(value="userreconnectdelay")
    @Produces(value={"text/event-stream"})
    public void sendUserRetry(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send((OutboundSseEvent)new OutboundSSEEventImpl(MESSAGE).setDelay(20000));
        }
    }
}

