/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.providers;

import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationServlet;
import ee.jakarta.tck.ws.rs.ee.rs.ext.contextresolver.EnumProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.exceptionmapper.AnyExceptionExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityAnnotation;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

@Path(value="ProvidersServlet")
public class ProvidersServlet
extends ApplicationServlet {
    @Context
    Providers providers;

    private EnumProvider getEnumProvider(MediaType type) {
        ContextResolver scr = this.providers.getContextResolver(EnumProvider.class, type);
        EnumProvider ep = (EnumProvider)((Object)scr.getContext(EnumProvider.class));
        return ep;
    }

    Response getResponseByEnumProvider(EnumProvider expected, EnumProvider given) {
        Response.Status status = Response.Status.NO_CONTENT;
        if (given != null) {
            status = given != expected ? Response.Status.NOT_ACCEPTABLE : Response.Status.OK;
        }
        return Response.status((Response.Status)status).build();
    }

    @GET
    @Path(value="isRegisteredContextResolver")
    public Response isRegisteredContextResolver() {
        EnumProvider ep = this.getEnumProvider(MediaType.WILDCARD_TYPE);
        return this.getResponseByEnumProvider(EnumProvider.JAXRS, ep);
    }

    @GET
    @Path(value="isRegisteredTextPlainContextResolver")
    public Response isRegisteredTextPlainContextResolver() {
        EnumProvider ep = this.getEnumProvider(MediaType.TEXT_PLAIN_TYPE);
        return this.getResponseByEnumProvider(EnumProvider.CTS, ep);
    }

    @GET
    @Path(value="isRegisteredAppJsonContextResolver")
    public Response isRegisteredAppJsonContextResolver() {
        EnumProvider ep = this.getEnumProvider(MediaType.APPLICATION_JSON_TYPE);
        return this.getResponseByEnumProvider(EnumProvider.JAXRS, ep);
    }

    @GET
    @Path(value="isRegisteredExceptionMapperRuntimeEx")
    public Response isRegisteredExceptionMapperRuntimeException() {
        ExceptionMapper em = this.providers.getExceptionMapper(Exception.class);
        return em.toResponse((Throwable)new RuntimeException());
    }

    @GET
    @Path(value="isRegisteredExceptionMapperNullEx")
    public Response isRegisteredExceptionMapperNullException() {
        ExceptionMapper em = this.providers.getExceptionMapper(Exception.class);
        return em.toResponse(null);
    }

    @GET
    @Path(value="isRegisteredRuntimeExceptionMapper")
    public Response isRegisteredRuntimeExceptionMapper() {
        ExceptionMapper em = this.providers.getExceptionMapper(RuntimeException.class);
        Response.Status status = Response.Status.NOT_ACCEPTABLE;
        if (em != null && AnyExceptionExceptionMapper.class.isInstance(em)) {
            status = Response.Status.OK;
        }
        return Response.serverError().status(status).build();
    }

    @GET
    @Path(value="isRegisteredIOExceptionMapper")
    public Response isRegisteredIOExceptionExceptionMapper() {
        ExceptionMapper em = this.providers.getExceptionMapper(IOException.class);
        return em.toResponse((Throwable)new IOException());
    }

    @GET
    @Path(value="isRegisteredMessageReaderWildCard")
    public Response isRegisteredEntityMessageReaderWildcard() {
        MessageBodyReader reader = this.providers.getMessageBodyReader(ReadableWritableEntity.class, null, this.getArgumentAnnotations("readEntityFromBody"), MediaType.WILDCARD_TYPE);
        Response.Status status = reader == null ? Response.Status.NOT_ACCEPTABLE : Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @GET
    @Path(value="isRegisteredMessageReaderXml")
    public Response isRegisteredEntityMessageReaderXml() {
        MessageBodyReader reader = this.providers.getMessageBodyReader(ReadableWritableEntity.class, null, this.getArgumentAnnotations("readEntityFromBody"), MediaType.TEXT_XML_TYPE);
        Response.Status status = reader == null ? Response.Status.NOT_ACCEPTABLE : Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @GET
    @Path(value="isRegisteredWriterWildcard")
    public Response isRegisteredWriterWildCard() {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(ReadableWritableEntity.class, null, this.getMethodAnnotations("writeBodyEntityUsingWriter"), MediaType.WILDCARD_TYPE);
        Response.Status status = writer == null ? Response.Status.NOT_ACCEPTABLE : Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @GET
    @Path(value="isRegisteredMessageWriterXml")
    public Response isRegisteredWriterXml() {
        MessageBodyWriter entity = this.providers.getMessageBodyWriter(ReadableWritableEntity.class, null, this.getMethodAnnotations("writeBodyEntityUsingWriter"), MediaType.TEXT_XML_TYPE);
        Response.Status status = entity == null ? Response.Status.NOT_ACCEPTABLE : Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="writeBodyEntityUsingWriter")
    public Response writeBodyEntityUsingWriter() {
        ReadableWritableEntity rwe = new ReadableWritableEntity(EnumProvider.JAXRS.name());
        return Response.ok((Object)rwe).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="writeHeaderEntityUsingWriter")
    public Response writeHeaderEntityUsingWriter() {
        ReadableWritableEntity rwe = new ReadableWritableEntity(EnumProvider.JAXRS.name());
        return Response.ok((Object)rwe).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="writeIOExceptionWithoutWriter")
    public Response writeIOExceptionWithoutWriter() throws IOException {
        throw new IOException("123 exception");
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="writeIOExceptionUsingWriter")
    public Response writeIOExceptionUsingWriter() throws IOException {
        ReadableWritableEntity rwe = new ReadableWritableEntity("");
        return Response.ok((Object)rwe).build();
    }

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="readEntityFromHeader")
    public Response readEntityFromHeader(@EntityAnnotation(value="Header") ReadableWritableEntity entity) {
        Response.Status status = Response.Status.NO_CONTENT;
        if (entity != null) {
            boolean b = entity.toString().equals(EnumProvider.JAXRS.name());
            status = b ? Response.Status.OK : Response.Status.NOT_ACCEPTABLE;
        }
        return Response.status((Response.Status)status).build();
    }

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="readEntityFromBody")
    public Response readEntityFromBody(@EntityAnnotation(value="Body") ReadableWritableEntity entity) {
        Response.Status status = Response.Status.NO_CONTENT;
        if (entity != null) {
            boolean b = entity.toString().equals(EnumProvider.JAXRS.name());
            status = b ? Response.Status.OK : Response.Status.NOT_ACCEPTABLE;
        }
        return Response.status((Response.Status)status).build();
    }

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="readEntityIOException")
    public Response readEntityIOException(@EntityAnnotation(value="IOException") ReadableWritableEntity entity) {
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="readEntityWebException")
    public Response readEntityWebException(@EntityAnnotation(value="WebException") ReadableWritableEntity entity) {
        return Response.ok().build();
    }

    private Annotation[] getMethodAnnotations(String methodName) {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method.getAnnotations();
        }
        return null;
    }

    private Annotation[] getArgumentAnnotations(String methodName) {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method.getParameterAnnotations()[0];
        }
        return null;
    }
}

