/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.client.clientrequestcontext;

import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.ContextProvider;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.ee.rs.client.clientrequestcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.client.clientrequestcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -3234850442044177095L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_client_clientrequestcontext_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/client/clientrequestcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_client_clientrequestcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ContextProvider.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getEntityStreamTest() throws JAXRSCommonClient.Fault {
        String entityStreamWorks = "ENTITY_STREAM_WORKS";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                OutputStream stream = context.getEntityStream();
                ReplacingOutputStream wrapper = new ReplacingOutputStream(stream, 'X', 'T');
                context.setEntityStream((OutputStream)wrapper);
            }
        };
        ByteArrayInputStream entity = new ByteArrayInputStream("ENTITY_STREAM_WORKS".replace('T', 'X').getBytes());
        this.addProvider(provider);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "post"));
        this.invoke();
        String body = this.getResponseBody();
        JAXRSClientIT.assertContains(body, "ENTITY_STREAM_WORKS");
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MultivaluedMap headers = context.getHeaders();
                headers.add((Object)"Accept-Language", (Object)"en_gb");
                headers.add((Object)"Date", (Object)"Tue, 15 Nov 1994 08:12:31 GMT");
                headers.add((Object)"tck", (Object)"cts");
            }
        };
        this.addProvider(provider);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "headers"));
        this.invoke();
        String body = this.getResponseBody().toLowerCase();
        JAXRSClientIT.assertContains(body, "accept-language");
        JAXRSClientIT.assertContains(body, "date");
        JAXRSClientIT.assertContains(body, "tck");
    }

    @Test
    public void setMethodTest() throws JAXRSCommonClient.Fault {
        String entity = "ENTITY";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                context.setMethod("PUT");
            }
        };
        this.addProvider(provider);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "put"));
        this.invoke();
        String body = this.getResponseBody();
        JAXRSClientIT.assertContains(body, entity);
    }

    @Test
    public void setUriTest() throws JAXRSCommonClient.Fault {
        String entity = "ENTITY";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                URI uri = context.getUri();
                try {
                    uri = new URI(uri.toASCIIString().replace("qwerty", "post"));
                }
                catch (URISyntaxException e) {
                    throw new JAXRSCommonClient.Fault(e);
                }
                context.setUri(uri);
            }
        };
        this.addProvider(provider);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "qwerty"));
        this.invoke();
        String body = this.getResponseBody();
        JAXRSClientIT.assertContains(body, entity);
    }

    protected static void assertContains(String string, String substring) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)string.contains(substring), (String)(string + "does NOT contain" + substring));
        TestUtil.logMsg("Found expected substring: " + substring);
    }
}

