/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.java2entity;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

@Provider
public class CollectionWriter
extends AbstractMessageBodyRW
implements MessageBodyWriter<Collection<?>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String path = CollectionWriter.getPathValue(annotations);
        if (path.equalsIgnoreCase(type.getSimpleName())) {
            return CollectionWriter.checkOther(type, genericType);
        }
        if (path.equalsIgnoreCase("response/linkedlist")) {
            return CollectionWriter.checkResponseNongeneric(type, genericType);
        }
        if (path.equalsIgnoreCase("response/genericentity/linkedlist")) {
            return CollectionWriter.checkGeneric(type, genericType);
        }
        if (path.equalsIgnoreCase("genericentity/linkedlist")) {
            return CollectionWriter.checkGeneric(type, genericType);
        }
        return false;
    }

    private static boolean checkOther(Class<?> type, Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pType = (ParameterizedType)genericType;
        boolean ok = pType.getRawType().equals(LinkedList.class);
        return ok &= pType.getActualTypeArguments()[0].equals(String.class);
    }

    private static boolean checkResponseNongeneric(Class<?> type, Type genericType) {
        boolean ok = genericType.equals(LinkedList.class);
        return ok &= type.equals(LinkedList.class);
    }

    private static boolean checkGeneric(Class<?> type, Type genericType) {
        if (ParameterizedType.class.isInstance(genericType)) {
            genericType = ((ParameterizedType)genericType).getRawType();
        }
        boolean ok = genericType.getClass().equals(List.class) || genericType.equals(LinkedList.class);
        return ok &= type.equals(LinkedList.class);
    }

    public long getSize(Collection<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Response.Status.OK.name().length();
    }

    public void writeTo(Collection<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(Response.Status.OK.name().getBytes());
    }
}

