/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class ExcludeListBrowser
extends ToolDialog {
    private static final int TEST_NAME_COL = 0;
    private static final int TEST_CASE_COL = 1;
    private static final int BUG_COL = 2;
    private static final int KEYWORDS_COL = 3;
    private static final int SYNOPSIS_COL = 4;
    private static final int COLUMN_COUNT = 5;
    private InterviewParameters params;
    private File[] files;
    private ExcludeList list;
    private ExcludeListTableModel model;
    private JTable table;
    private JTextField synopsisField;
    private JTextField kwField;
    private JTextField bugIdsField;
    private Listener listener = new Listener();
    private String[] columnNames;

    ExcludeListBrowser(Container parent, UIFactory uif) {
        super(parent, uif, "elb");
    }

    public void show(InterviewParameters params) {
        this.params = params;
        this.setVisible(true);
    }

    private void updateContent() {
        ExcludeList exclList = this.params.getExcludeList();
        Parameters.ExcludeListParameters eParams = this.params.getExcludeListParameters();
        File[] exclFiles = eParams instanceof Parameters.MutableExcludeListParameters ? ((Parameters.MutableExcludeListParameters)eParams).getExcludeFiles() : null;
        if (this.list != exclList || this.files != exclFiles || this.model == null || this.list.size() != this.model.getRowCount()) {
            this.setTable(exclFiles, exclList);
        }
    }

    private void setTable(File[] files, ExcludeList list) {
        this.list = list;
        this.files = files;
        this.model = new ExcludeListTableModel(list);
        this.table.setModel(this.model);
        if (this.model.getRowCount() == 0) {
            this.setI18NTitle("elb.title0");
        } else {
            this.setI18NTitle("elb.title1", (Object)String.valueOf(this.model.getRowCount()));
        }
    }

    @Override
    protected void initGUI() {
        this.setHelp("exclList.window.csh");
        JPanel body = this.uif.createPanel("elb.body", new GridBagLayout(), false);
        body.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int dpi = this.uif.getDotsPerInch();
        body.setPreferredSize(new Dimension(5 * dpi, 2 * dpi));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.insets.bottom = 5;
        this.table = new JTable();
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(e -> this.showSelectedEntry());
        this.uif.setAccessibleInfo(this.table, "elb.tbl");
        this.uif.setToolTip(this.table, "elb.tbl");
        body.add((Component)new JScrollPane(this.table), c);
        GridBagConstraints lc = new GridBagConstraints();
        lc.insets.top = 2;
        lc.insets.right = 5;
        lc.anchor = 13;
        GridBagConstraints fc = new GridBagConstraints();
        fc.gridwidth = 0;
        fc.insets.top = 2;
        fc.weightx = 1.0;
        fc.fill = 2;
        JLabel synopsisLabel = this.uif.createLabel("elb.synopsis", true);
        body.add((Component)synopsisLabel, lc);
        this.synopsisField = this.uif.createOutputField("elb.synopsis", synopsisLabel);
        body.add((Component)this.synopsisField, fc);
        JLabel kwLabel = this.uif.createLabel("elb.kws", true);
        body.add((Component)kwLabel, lc);
        this.kwField = this.uif.createOutputField("elb.kws", kwLabel);
        body.add((Component)this.kwField, fc);
        JLabel bugIdsLabel = this.uif.createLabel("elb.bugids", true);
        body.add((Component)bugIdsLabel, lc);
        this.bugIdsField = this.uif.createOutputField("elb.bugids", bugIdsLabel);
        body.add((Component)this.bugIdsField, fc);
        this.setBody(body);
        JButton helpBtn = this.uif.createHelpButton("elb.help", "exclList.window.csh");
        JButton closeBtn = this.uif.createCloseButton("elb.close");
        this.setButtons(new JButton[]{helpBtn, closeBtn}, closeBtn);
        this.setComponentListener(this.listener);
    }

    private void showSelectedEntry() {
        ExcludeList.Entry e = this.model.getEntry(this.table.getSelectedRow());
        if (e == null) {
            this.synopsisField.setText("");
            this.kwField.setText("");
            this.bugIdsField.setText("");
        } else {
            this.synopsisField.setText(e.getSynopsis());
            this.kwField.setText(this.getKeywords(e));
            this.bugIdsField.setText(this.getBugIds(e));
        }
    }

    private String entryToString(ExcludeList.Entry e) {
        String u = e.getRelativeURL();
        String tc = e.getTestCases();
        return tc == null ? u : u + "[" + tc + "]";
    }

    private String getBugIds(ExcludeList.Entry e) {
        String[] bugIds = e.getBugIdStrings();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bugIds.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(bugIds[i]);
        }
        return sb.toString();
    }

    private String getKeywords(ExcludeList.Entry e) {
        String[] keywords = e.getPlatforms();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keywords.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(keywords[i]);
        }
        return sb.toString();
    }

    static /* synthetic */ String[] access$302(ExcludeListBrowser x0, String[] x1) {
        x0.columnNames = x1;
        return x1;
    }

    private class ExcludeListTableModel
    implements TableModel {
        private ExcludeList.Entry[] entries;

        ExcludeListTableModel(ExcludeList list) {
            if (ExcludeListBrowser.this.columnNames == null) {
                ExcludeListBrowser.access$302(ExcludeListBrowser.this, new String[5]);
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[0] = ExcludeListBrowser.this.uif.getI18NString("elb.col.testName");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[1] = ExcludeListBrowser.this.uif.getI18NString("elb.col.testCase");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[2] = ExcludeListBrowser.this.uif.getI18NString("elb.col.bugId");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[3] = ExcludeListBrowser.this.uif.getI18NString("elb.col.keywords");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[4] = ExcludeListBrowser.this.uif.getI18NString("elb.col.synopsis");
            }
            TreeSet<ExcludeList.Entry> sortedEntries = new TreeSet<ExcludeList.Entry>((o1, o2) -> {
                String s1 = ExcludeListBrowser.this.entryToString(o1);
                String s2 = ExcludeListBrowser.this.entryToString(o2);
                return s1.compareTo(s2);
            });
            if (list != null) {
                Iterator<?> iter = list.getIterator(false);
                while (iter.hasNext()) {
                    ExcludeList.Entry ee = (ExcludeList.Entry)iter.next();
                    sortedEntries.add(ee);
                }
            }
            this.entries = new ExcludeList.Entry[sortedEntries.size()];
            sortedEntries.toArray(this.entries);
        }

        ExcludeList.Entry getEntry(int index) {
            return index < 0 || index >= this.entries.length ? null : this.entries[index];
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int index) {
            return ExcludeListBrowser.this.columnNames[index];
        }

        @Override
        public int getRowCount() {
            return this.entries.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            ExcludeList.Entry e = this.entries[rowIndex];
            switch (colIndex) {
                case 0: {
                    return e.getRelativeURL();
                }
                case 1: {
                    return e.getTestCases();
                }
                case 2: {
                    return ExcludeListBrowser.this.getBugIds(e);
                }
                case 3: {
                    return ExcludeListBrowser.this.getKeywords(e);
                }
                case 4: {
                    return e.getSynopsis();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int colIndex) {
            throw new UnsupportedOperationException();
        }
    }

    private class Listener
    extends ComponentAdapter
    implements Interview.Observer {
        private Listener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ExcludeListBrowser.this.params.addObserver(this);
            ExcludeListBrowser.this.updateContent();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ExcludeListBrowser.this.params.removeObserver(this);
        }

        @Override
        public void currentQuestionChanged(Question q) {
        }

        @Override
        public void pathUpdated() {
            ExcludeListBrowser.this.updateContent();
        }
    }
}

