/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.orderby;

import com.sun.ts.tests.jpa.core.annotations.orderby.ZipCode2;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import java.io.Serializable;

@Embeddable
public class Address2
implements Serializable {
    protected String street;
    protected String city;
    protected String state;
    protected ZipCode2 zipcode;

    public Address2() {
    }

    public Address2(String street, String city, String state) {
        this.street = street;
        this.city = city;
        this.state = state;
    }

    public Address2(String street, String city, String state, ZipCode2 zip) {
        this.street = street;
        this.city = city;
        this.state = state;
        this.zipcode = zip;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Embedded
    public ZipCode2 getZipCode() {
        return this.zipcode;
    }

    public void setZipCode(ZipCode2 zipcode) {
        this.zipcode = zipcode;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof Address2)) {
            return result;
        }
        Address2 other = (Address2)o;
        if (this.getStreet().equals(other.getStreet()) && this.getCity().equals(other.getCity()) && this.getState().equals(other.getState()) && this.getZipCode().getZip().equals(other.getZipCode().getZip())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int myHash = this.getStreet().hashCode() + this.getCity().hashCode() + this.getState().hashCode() + this.getZipCode().getZip().hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("street: " + this.getStreet());
        result.append(", city: " + this.getCity());
        result.append(", state: " + this.getState());
        result.append(", zip: " + this.getZipCode().getZip());
        result.append("]");
        return result.toString();
    }
}

