/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.PackageList;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.Version;
import javasoft.sqe.apiCheck.WriteJh;

public class Setup {
    static String[] pars = new String[]{"in$s", "package$m$s", "expackage$m$s", "out$s", "defpack$s", "nodefpack", "xpriv", "constvalues", "reflect", "static", "version"};
    static String help = "Options are:\n-in <spec>\n-out <file>\n-package <packs>\n-expackage <packs>\n-constvalues\n-defpack <pack>\n-nodefpack\n-xpriv\n-reflect\n-static\n-version";

    public static void main(String[] args) {
        Main.args.clear();
        if (!Main.args.Parse(args, pars) || Main.args.isEmpty()) {
            System.err.println(help);
            return;
        }
        if (Main.args.getProperty("version") != null) {
            System.out.println("Version: " + Version.Ident());
            if (Main.args.size() == 1) {
                return;
            }
        }
        PackageSet packs = new PackageSet(Main.args.getProperty("package"), Main.args.getProperty("expackage"));
        String defpack = Main.args.getProperty("defpack");
        if (Main.args.getProperty("nodefpack") == null) {
            if (defpack == null) {
                defpack = "java.lang";
            }
        } else if (defpack != null) {
            Setup.Stop("error in options -defpack/-nodefpack");
        }
        if (defpack != null) {
            Main.args.setProperty("defpack", defpack);
        }
        String inpath = Main.args.getProperty("in");
        API api = new API();
        api.ReadPath(inpath, packs);
        if (api.IsEmpty()) {
            Setup.Stop("no classes found in \"" + api.props.Find("classpath") + "\"");
        }
        api.GetXProg().Sort();
        WriteJh writer = new WriteJh();
        if (Main.args.getProperty("out") == null) {
            writer.Write(api, System.out);
        } else {
            writer.Write(api, Main.args.getProperty("out"));
        }
        writer.Close();
        String packageSigFile = Main.args.getProperty("out", "");
        String additionalPackage = Main.args.getProperty("package", "");
        String packageListFile = System.getProperty("pkg.list.file.path", "");
        try {
            PackageList pList = new PackageList(additionalPackage, packageSigFile, packageListFile);
            pList.writePkgListFile();
        }
        catch (Exception e) {
            System.err.println("Setup.main() - Error updating the package list file \"" + packageListFile + "\" with the package named \"" + additionalPackage + "\"");
        }
    }

    static void Stop(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("Setup terminated.");
        System.exit(1);
    }
}

