/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.batch.ObserverCommand;
import com.sun.javatest.batch.RunTestsCommand;
import com.sun.javatest.report.ReportManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.ListIterator;

public class BatchManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BatchManager.class);

    @Override
    public HelpTree.Node getHelp() {
        HelpTree.Node[] cmdNodes = new HelpTree.Node[]{this.getCommandHelp(BatchCommand.getName()), ObserverCommand.getHelp(), this.getCommandHelp(RunTestsCommand.getName())};
        return new HelpTree.Node(i18n, "cmgr.help", cmdNodes);
    }

    private HelpTree.Node getCommandHelp(String name) {
        return new HelpTree.Node(i18n, "cmgr.help." + name);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (BatchManager.isMatch(cmd, BatchCommand.getName())) {
            ctx.addCommand(new BatchCommand());
            return true;
        }
        if (BatchManager.isMatch(cmd, ObserverCommand.getName())) {
            ctx.addCommand(new ObserverCommand(argIter));
            return true;
        }
        if (BatchManager.isMatch(cmd, RunTestsCommand.getName())) {
            ctx.addCommand(new RunTestsCommand(argIter));
            return true;
        }
        return false;
    }

    static {
        RunTestsCommand.initVerboseOptions();
    }

    static class AutoRunCommand
    extends RunTestsCommand {
        AutoRunCommand() {
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            super.run(ctx);
            File reportDir = ctx.getAutoRunReportDir();
            if (reportDir != null) {
                ReportManager.writeReport(reportDir, ctx);
            }
        }
    }

    static class BatchCommand
    extends Command {
        BatchCommand() {
            super(BatchCommand.getName());
        }

        static String getName() {
            return "batch";
        }

        @Override
        public int getDesktopMode() {
            return 1;
        }

        @Override
        public void run(CommandContext ctx) {
            ctx.setAutoRunCommand(new AutoRunCommand());
            ctx.setCloseDesktopWhenDoneEnabled(true);
        }
    }
}

