/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public abstract class FileListQuestion
extends Question {
    private static final File[] empty = new File[0];
    protected File[] value;
    private File[] defaultValue;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;
    private FileFilter[] hintFilters;
    private boolean duplicatesAllowed = true;

    protected FileListQuestion(Interview interview, String tag) {
        super(interview, tag);
        if (interview.getInterviewSemantics() > 0) {
            this.clear();
        }
        this.setDefaultValue(this.value);
    }

    public File[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(File[] v) {
        this.defaultValue = v;
    }

    public void setDuplicatesAllowed(boolean b) {
        this.duplicatesAllowed = b;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public File[] getValue() {
        return this.value;
    }

    public File[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return FileListQuestion.join(this.value);
    }

    @Override
    public void setValue(String paths) {
        this.setValue(paths == null ? (File[])null : FileListQuestion.split(paths));
    }

    public void setValue(File[] newValue) {
        File[] oldValue = this.value;
        this.value = newValue;
        if (!FileListQuestion.equal(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    @Override
    public boolean isValueValid() {
        if (this.interview.getInterviewSemantics() < 3) {
            return true;
        }
        if (this.value == null || this.value.length == 0 || this.filters == null || this.filters.length == 0) {
            return true;
        }
        for (File f : this.value) {
            if (f == null) continue;
            for (FileFilter fs : this.filters) {
                if (fs == null || fs.accept(f)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilter(FileFilter filter) {
        this.filters = new FileFilter[]{filter};
    }

    public void setFilters(FileFilter[] fs) {
        if (this.interview.getInterviewSemantics() >= 3) {
            this.filters = fs;
        } else {
            this.hintFilters = fs;
            this.filters = fs;
        }
    }

    public void setHintFilters(FileFilter[] fs) {
        this.hintFilters = fs;
    }

    public FileFilter[] getHintFilters() {
        if (this.interview.getInterviewSemantics() >= 3) {
            return this.hintFilters;
        }
        return this.filters;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File dir) {
        this.baseDir = dir;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean b) {
        this.baseRelativeOnly = b;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map data) {
        Object o = data.get(this.tag);
        if (o instanceof File[]) {
            this.setValue((File[])o);
        } else if (o instanceof String) {
            this.setValue(FileListQuestion.split((String)o));
        }
    }

    public static File[] split(String s) {
        if (s == null) {
            return empty;
        }
        char sep = s.indexOf(10) == -1 ? (char)' ' : '\n';
        ArrayList<File> v = new ArrayList<File>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == sep) {
                if (start != -1) {
                    v.add(new File(s.substring(start, i)));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            v.add(new File(s.substring(start)));
        }
        if (v.size() == 0) {
            return empty;
        }
        File[] a = new File[v.size()];
        v.toArray(a);
        return a;
    }

    @Override
    protected void save(Map data) {
        if (this.value != null) {
            data.put(this.tag, FileListQuestion.join(this.value));
        }
    }

    public static String join(File[] ff) {
        if (ff == null || ff.length == 0) {
            return "";
        }
        int l = ff.length - 1;
        for (int i = 0; i < ff.length; ++i) {
            l += ff[i].getPath().length();
        }
        StringBuffer sb = new StringBuffer(l);
        String ff0p = ff[0].getPath();
        sb.append(ff0p);
        if (ff.length == 1 && ff0p.indexOf(32) != -1) {
            sb.append('\n');
        } else {
            for (int i = 1; i < ff.length; ++i) {
                sb.append('\n');
                sb.append(ff[i].getPath());
            }
        }
        return sb.toString();
    }

    protected static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }
}

