/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DIGESTMD5BindRequestProperties
implements Serializable {
    private static final long serialVersionUID = -2000440962628192477L;
    private ASN1OctetString password;
    private List<SASLQualityOfProtection> allowedQoP;
    private String authenticationID;
    private String authorizationID;
    private String realm;

    public DIGESTMD5BindRequestProperties(String authenticationID, String password) {
        this(authenticationID, new ASN1OctetString(password));
    }

    public DIGESTMD5BindRequestProperties(String authenticationID, byte[] password) {
        this(authenticationID, new ASN1OctetString(password));
    }

    public DIGESTMD5BindRequestProperties(String authenticationID, ASN1OctetString password) {
        Validator.ensureNotNull(authenticationID);
        this.authenticationID = authenticationID;
        this.password = password == null ? new ASN1OctetString() : password;
        this.authorizationID = null;
        this.realm = null;
        this.allowedQoP = Collections.unmodifiableList(Arrays.asList(SASLQualityOfProtection.AUTH));
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(String authenticationID) {
        Validator.ensureNotNull(authenticationID);
        this.authenticationID = authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.setPassword(new ASN1OctetString(password));
    }

    public void setPassword(byte[] password) {
        this.setPassword(new ASN1OctetString(password));
    }

    public void setPassword(ASN1OctetString password) {
        this.password = password == null ? new ASN1OctetString() : password;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public List<SASLQualityOfProtection> getAllowedQoP() {
        return this.allowedQoP;
    }

    public void setAllowedQoP(List<SASLQualityOfProtection> allowedQoP) {
        this.allowedQoP = allowedQoP == null || allowedQoP.isEmpty() ? Collections.unmodifiableList(Arrays.asList(SASLQualityOfProtection.AUTH)) : Collections.unmodifiableList(new ArrayList<SASLQualityOfProtection>(allowedQoP));
    }

    public void setAllowedQoP(SASLQualityOfProtection ... allowedQoP) {
        this.setAllowedQoP(StaticUtils.toList(allowedQoP));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DIGESTMD5BindRequestProperties(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        buffer.append(", qop='");
        buffer.append(SASLQualityOfProtection.toString(this.allowedQoP));
        buffer.append("')");
    }
}

