/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.response;

import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.CorruptedInputStream;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;

@Path(value="resource")
public class ResponseTest {
    public static final String ENTITY = "ENtiTy";

    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public Response statusTest(@QueryParam(value="status") int status) {
        StringBuffer sb = new StringBuffer();
        sb.append("status code in request = " + status);
        Response.ResponseBuilder builder = Response.status((int)status);
        Response res = builder.header("TESTHEADER", (Object)sb.toString()).build();
        return res;
    }

    @GET
    @Path(value="entity")
    @Produces(value={"text/plain"})
    public String entity() {
        return ENTITY;
    }

    @GET
    @Path(value="corrupted")
    public CorruptedInputStream corrupted() {
        return new CorruptedInputStream(ENTITY.getBytes(), null);
    }

    @GET
    @Path(value="date")
    public String date(@QueryParam(value="date") String date) {
        return date;
    }

    @POST
    @Path(value="allowedmethods")
    public Response getAllowedMethods(String methods) {
        Response.ResponseBuilder builder = Response.ok();
        StringTokenizer tokenizer = new StringTokenizer(methods);
        LinkedList<String> allowed = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            allowed.add(tokenizer.nextToken());
        }
        builder.allow(allowed.toArray(new String[0]));
        return builder.build();
    }

    @GET
    @Path(value="cookies")
    public Response getCookies() {
        NewCookie cookie1 = new NewCookie("c1", "v1");
        NewCookie cookie2 = new NewCookie("c2", "v2");
        Response response = Response.ok().cookie(new NewCookie[]{cookie1}).cookie(new NewCookie[]{cookie2}).build();
        return response;
    }

    @POST
    @Path(value="date")
    public Response getDate(String date) throws InterruptedException {
        Response.ResponseBuilder builder = Response.ok();
        Thread.sleep(1500L);
        if (date != null && date.length() != 0) {
            long millis = Long.parseLong(date);
            Date dateFromMillis = new Date(millis);
            builder = builder.header("Date", (Object)dateFromMillis);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="entitytag")
    public Response getEntityTag(String tag) {
        Response.ResponseBuilder builder;
        if (tag != null && tag.length() != 0) {
            EntityTag entityTag = new EntityTag(tag);
            builder = Response.notModified((EntityTag)entityTag);
        } else {
            builder = Response.ok();
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="headers")
    public Response getHeaders(String headers) {
        CacheControl ccl = new CacheControl();
        NewCookie cookie = new NewCookie("cookie", "eikooc");
        String encoding = "gzip";
        Date date = Calendar.getInstance().getTime();
        Response.ResponseBuilder builder = Response.ok();
        if (headers != null && headers.length() != 0) {
            builder = builder.cacheControl(ccl).cookie(new NewCookie[]{cookie}).encoding(encoding).expires(date).language(Locale.CANADA_FRENCH);
        }
        return builder.build();
    }

    @POST
    @Path(value="headerstring")
    public Response getHeaderString(String headers) {
        StringBuilder builder = new StringBuilder("s1");
        StringBuffer buffer = new StringBuffer("s2");
        StringBean bean = new StringBean("s3");
        Response.ResponseBuilder response = Response.ok();
        if (headers != null && headers.length() != 0) {
            response = response.header(builder.toString(), (Object)builder).header(buffer.toString(), (Object)buffer).header(bean.get(), (Object)bean);
        }
        return response.build();
    }

    @POST
    @Path(value="language")
    public Response getLanguage(String lang) {
        Response.ResponseBuilder builder = Response.ok();
        Locale locale = null;
        if (Locale.CANADA_FRENCH.getCountry().equals(lang)) {
            locale = Locale.CANADA_FRENCH;
        }
        if (locale != null) {
            builder = builder.language(locale);
        }
        return builder.build();
    }

    @POST
    @Path(value="lastmodified")
    public Response lastModified(String date) {
        Response.ResponseBuilder builder = Response.ok();
        if (date != null && date.length() != 0) {
            long millis = Long.parseLong(date);
            Date dateFromMillis = new Date(millis);
            builder = builder.lastModified(dateFromMillis);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="length")
    public Response getLength(String entity) {
        Response response = null;
        response = entity == null || entity.length() == 0 ? Response.ok().build() : Response.ok((Object)entity).header("Content-Length", (Object)entity.length()).build();
        return response;
    }

    @POST
    @Path(value="link")
    public Response getLink(String rel) {
        Response.ResponseBuilder builder = Response.ok();
        if (rel != null && rel.length() != 0) {
            builder.links(new Link[]{ResponseTest.createLink("path", rel)});
        }
        return builder.build();
    }

    @POST
    @Path(value="linkbuilder")
    public Response getLinkBuilder(String rel) {
        Link link1 = ResponseTest.createLink("path1", rel);
        Response response = Response.ok().links(new Link[]{link1}).build();
        Link builderLink = response.getLinkBuilder(rel).build(new Object[0]);
        response = Response.ok().links(new Link[]{builderLink}).build();
        return response;
    }

    @GET
    @Path(value="links")
    public Response getLinks() {
        Link link1 = ResponseTest.createLink("path1", "rel1");
        Link link2 = ResponseTest.createLink("path2", "rel2");
        Response response = Response.ok().links(new Link[]{link1, link2}).build();
        return response;
    }

    @POST
    @Path(value="location")
    public Response getLocation(String path) {
        URI location = ResponseTest.createUri(path);
        Response response = Response.ok().location(location).build();
        return response;
    }

    @POST
    @Path(value="mediatype")
    public Response getMediaType(String mediaType) {
        MediaType media = MediaType.WILDCARD_TYPE;
        if (mediaType.equals("application/atom+xml")) {
            media = MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        Response response = Response.ok().type(media).build();
        return response;
    }

    @POST
    @Path(value="statusinfo")
    public Response getStatusInfo(String status) {
        Response.Status stat = Response.Status.valueOf((String)status);
        Response response = Response.status((Response.Status)stat).build();
        return response;
    }

    @Path(value="setstringbeanruntime")
    @GET
    public Response setStringBeanRuntime() {
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        if (!(original instanceof StringBeanRuntimeDelegate)) {
            StringBeanRuntimeDelegate sbrd = new StringBeanRuntimeDelegate(original);
            RuntimeDelegate.setInstance((RuntimeDelegate)sbrd);
        }
        return Response.ok().build();
    }

    @Path(value="setoriginalruntime")
    @GET
    public Response setOriginalRuntime() {
        Response response = null;
        RuntimeDelegate stringBeanDelegate = RuntimeDelegate.getInstance();
        if (stringBeanDelegate instanceof StringBeanRuntimeDelegate) {
            RuntimeDelegate original = ((StringBeanRuntimeDelegate)stringBeanDelegate).getOriginal();
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            response = Response.ok().build();
        } else {
            response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return response;
    }

    @Path(value="created")
    @GET
    public Response setLocationHeader() {
        try {
            Response response = Response.created((URI)new URI("created")).status(200).build();
            return response;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Link createLink(String path, String rel) {
        return Link.fromUri((URI)ResponseTest.createUri(path)).rel(rel).build(new Object[0]);
    }

    protected static URI createUri(String path) {
        URI uri;
        try {
            uri = new URI("http://localhost.tck:888/url404/" + path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }
}

