/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam.impl;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.BSDCLibrary;
import org.jvnet.libpam.impl.FreeBSDCLibrary;
import org.jvnet.libpam.impl.LinuxCLibrary;
import org.jvnet.libpam.impl.SolarisCLibrary;

public interface CLibrary
extends Library {
    public static final CLibrary libc = Instance.init();

    public Pointer calloc(int var1, int var2);

    public Pointer strdup(String var1);

    public Passwd getpwnam(String var1);

    public int getgrouplist(String var1, int var2, Memory var3, IntByReference var4);

    public int _getgroupsbymember(String var1, Memory var2, int var3, int var4);

    public Group getgrgid(int var1);

    public Group getgrnam(String var1);

    public static class Instance {
        private static CLibrary init() {
            if (Platform.isMac() || Platform.isOpenBSD()) {
                return (CLibrary)Native.loadLibrary((String)"c", BSDCLibrary.class);
            }
            if (Platform.isFreeBSD()) {
                return (CLibrary)Native.loadLibrary((String)"c", FreeBSDCLibrary.class);
            }
            if (Platform.isSolaris()) {
                return (CLibrary)Native.loadLibrary((String)"c", SolarisCLibrary.class);
            }
            if (Platform.isLinux()) {
                return (CLibrary)Native.loadLibrary((String)"c", LinuxCLibrary.class);
            }
            return (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
        }
    }

    public static class Group
    extends Structure {
        public String gr_name;

        protected List getFieldOrder() {
            return Arrays.asList("gr_name");
        }

        public void setGrName(String gr_name) {
            this.gr_name = gr_name;
        }
    }

    public static class Passwd
    extends Structure {
        public String pw_name;
        public String pw_passwd;
        public int pw_uid;
        public int pw_gid;

        public static Passwd loadPasswd(String userName) throws PAMException {
            Passwd pwd = libc.getpwnam(userName);
            if (pwd == null) {
                throw new PAMException("No user information is available");
            }
            return pwd;
        }

        public String getPwName() {
            return this.pw_name;
        }

        public String getPwPasswd() {
            return this.pw_passwd;
        }

        public int getPwUid() {
            return this.pw_uid;
        }

        public int getPwGid() {
            return this.pw_gid;
        }

        public String getPwGecos() {
            return null;
        }

        public String getPwDir() {
            return null;
        }

        public String getPwShell() {
            return null;
        }

        protected List getFieldOrder() {
            return Arrays.asList("pw_name", "pw_passwd", "pw_uid", "pw_gid");
        }

        public void setPwName(String pw_name) {
            this.pw_name = pw_name;
        }

        public void setPwPasswd(String pw_passwd) {
            this.pw_passwd = pw_passwd;
        }

        public void setPwUid(int pw_uid) {
            this.pw_uid = pw_uid;
        }

        public void setPwGid(int pw_gid) {
            this.pw_gid = pw_gid;
        }
    }
}

