/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenIdProviderData {
    private final JsonObject document;
    private String issuerURI;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String endSessionEndpoint;
    private URL jwksURL;
    private final Set<String> scopesSupported;
    private Set<String> responseTypeSupported;
    private Set<String> idTokenSigningAlgorithmsSupported;
    private Set<String> subjectTypesSupported;

    public OpenIdProviderData(JsonObject document) {
        this.document = document;
        this.scopesSupported = this.getValues("scopes_supported");
    }

    public String getIssuerURI() {
        return this.issuerURI;
    }

    public OpenIdProviderData setIssuer(String issuerURI) {
        this.issuerURI = issuerURI;
        return this;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public OpenIdProviderData setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public OpenIdProviderData setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public OpenIdProviderData setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
        return this;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public OpenIdProviderData setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    public URL getJwksURL() {
        return this.jwksURL;
    }

    public OpenIdProviderData setJwksURL(URL jwksURL) {
        this.jwksURL = jwksURL;
        return this;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public Set<String> getResponseTypeSupported() {
        return this.responseTypeSupported;
    }

    public OpenIdProviderData setResponseTypeSupported(Set<String> responseTypeSupported) {
        this.responseTypeSupported = responseTypeSupported;
        return this;
    }

    public Set<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public OpenIdProviderData setSubjectTypesSupported(Set<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
        return this;
    }

    public Set<String> getIdTokenSigningAlgorithmsSupported() {
        return this.idTokenSigningAlgorithmsSupported;
    }

    public OpenIdProviderData setIdTokenSigningAlgorithmsSupported(Set<String> idTokenSigningAlgorithmsSupported) {
        this.idTokenSigningAlgorithmsSupported = idTokenSigningAlgorithmsSupported;
        return this;
    }

    private Set<String> getValues(String key) {
        JsonArray jsonArray = this.document.getJsonArray(key);
        if (Objects.isNull(jsonArray)) {
            return Collections.emptySet();
        }
        return jsonArray.stream().filter(element -> element.getValueType() == JsonValue.ValueType.STRING).map(element -> (JsonString)element).map(JsonString::getString).collect(Collectors.toSet());
    }

    public String toString() {
        return OpenIdProviderData.class.getSimpleName() + "{issuerURI=" + this.issuerURI + ", authorizationEndpoint=" + this.authorizationEndpoint + ", tokenEndpoint=" + this.tokenEndpoint + ", userinfoEndpoint=" + this.userinfoEndpoint + ", jwksURI=" + this.jwksURL + "}";
    }
}

