/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXML;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXMLMappings;

public class PersistenceUnitReader {
    protected final MetadataLogger logger;
    protected final ProcessingEnvironment processingEnv;

    public PersistenceUnitReader(MetadataLogger logger, ProcessingEnvironment processingEnv) {
        this.logger = logger;
        this.processingEnv = processingEnv;
    }

    protected void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
    }

    protected FileObject getFileObject(String filename, ProcessingEnvironment processingEnv) throws IOException {
        return processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
    }

    protected InputStream getInputStream(String filename, boolean loadingPersistenceXML) {
        InputStream inputStream;
        block5: {
            inputStream = null;
            try {
                FileObject fileObject = this.getFileObject(filename, this.processingEnv);
                inputStream = fileObject.openInputStream();
            }
            catch (Exception ioe) {
                try {
                    inputStream = new FileInputStream(filename);
                }
                catch (IOException e) {
                    if (loadingPersistenceXML) {
                        this.logger.getSession().getSessionLog().log(6, "processor", "The persistence xml file [{0}] was not found. NO GENERATION will occur!! Please ensure a persistence xml file is available either from the CLASS_OUTPUT directory [META-INF/persistence.xml] or using the eclipselink.persistencexml property to specify its location.", new Object[]{filename}, false);
                        break block5;
                    }
                    this.logger.getSession().getSessionLog().log(5, "processor", "Optional file was not found: {0} continuing with generation.", new Object[]{filename}, false);
                }
            }
        }
        return inputStream;
    }

    protected HashSet<String> getPersistenceUnitList(ProcessingEnvironment processingEnv) {
        String persistenceUnits = processingEnv.getOptions().get("eclipselink.persistenceunits");
        HashSet<String> persistenceUnitList = null;
        if (persistenceUnits != null) {
            persistenceUnitList = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(persistenceUnits, ",");
            while (st.hasMoreTokens()) {
                persistenceUnitList.add(st.nextToken().trim());
            }
        }
        return persistenceUnitList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPersistenceUnits(MetadataMirrorFactory factory) {
        block9: {
            if (Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.load_xml", "true", this.processingEnv.getOptions()))) {
                String filename = CanonicalModelProperties.getOption("eclipselink.persistencexml", "META-INF/persistence.xml", this.processingEnv.getOptions());
                HashSet<String> persistenceUnitList = this.getPersistenceUnitList(this.processingEnv);
                InputStream in = null;
                InputStream inStream1 = null;
                InputStream inStream2 = null;
                try {
                    PersistenceXML persistenceXML;
                    in = this.getInputStream(filename, true);
                    if (in == null) break block9;
                    try {
                        persistenceXML = (PersistenceXML)PersistenceXMLMappings.createXML3_0Context().createUnmarshaller().unmarshal(in);
                    }
                    catch (Throwable t) {
                        try {
                            inStream1 = this.getInputStream(filename, true);
                            persistenceXML = (PersistenceXML)PersistenceXMLMappings.createXML2_1Context().createUnmarshaller().unmarshal(inStream1);
                        }
                        catch (Exception e) {
                            inStream2 = this.getInputStream(filename, true);
                            persistenceXML = (PersistenceXML)PersistenceXMLMappings.createXML2_0Context().createUnmarshaller().unmarshal(inStream2);
                        }
                    }
                    for (SEPersistenceUnitInfo puInfo : persistenceXML.getPersistenceUnitInfos()) {
                        if (persistenceUnitList != null && !persistenceUnitList.contains(puInfo.getPersistenceUnitName())) continue;
                        factory.addPersistenceUnit(puInfo, new PersistenceUnit(puInfo, factory, this));
                    }
                }
                finally {
                    this.closeInputStream(in);
                    this.closeInputStream(inStream1);
                    this.closeInputStream(inStream2);
                }
            }
        }
    }
}

