/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.ByteExpression;
import org.glassfish.rmic.tools.tree.CharExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.DoubleExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FloatExpression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.IntegerExpression;
import org.glassfish.rmic.tools.tree.LongExpression;
import org.glassfish.rmic.tools.tree.ShortExpression;
import org.glassfish.rmic.tools.tree.UnaryExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class ConvertExpression
extends UnaryExpression {
    public ConvertExpression(long where, Type type, Expression right) {
        super(55, where, type, right);
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        return this.right.checkValue(env, ctx, vset, exp);
    }

    @Override
    Expression simplify() {
        switch (this.right.op) {
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                int value = ((IntegerExpression)this.right).value;
                switch (this.type.getTypeCode()) {
                    case 1: {
                        return new ByteExpression(this.right.where, (byte)value);
                    }
                    case 2: {
                        return new CharExpression(this.right.where, (char)value);
                    }
                    case 3: {
                        return new ShortExpression(this.right.where, (short)value);
                    }
                    case 4: {
                        return new IntExpression(this.right.where, value);
                    }
                    case 5: {
                        return new LongExpression(this.right.where, (long)value);
                    }
                    case 6: {
                        return new FloatExpression(this.right.where, (float)value);
                    }
                    case 7: {
                        return new DoubleExpression(this.right.where, (double)value);
                    }
                }
                break;
            }
            case 66: {
                long value = ((LongExpression)this.right).value;
                switch (this.type.getTypeCode()) {
                    case 1: {
                        return new ByteExpression(this.right.where, (byte)value);
                    }
                    case 2: {
                        return new CharExpression(this.right.where, (char)value);
                    }
                    case 3: {
                        return new ShortExpression(this.right.where, (short)value);
                    }
                    case 4: {
                        return new IntExpression(this.right.where, (int)value);
                    }
                    case 6: {
                        return new FloatExpression(this.right.where, (float)value);
                    }
                    case 7: {
                        return new DoubleExpression(this.right.where, (double)value);
                    }
                }
                break;
            }
            case 67: {
                float value = ((FloatExpression)this.right).value;
                switch (this.type.getTypeCode()) {
                    case 1: {
                        return new ByteExpression(this.right.where, (byte)value);
                    }
                    case 2: {
                        return new CharExpression(this.right.where, (char)value);
                    }
                    case 3: {
                        return new ShortExpression(this.right.where, (short)value);
                    }
                    case 4: {
                        return new IntExpression(this.right.where, (int)value);
                    }
                    case 5: {
                        return new LongExpression(this.right.where, (long)value);
                    }
                    case 7: {
                        return new DoubleExpression(this.right.where, value);
                    }
                }
                break;
            }
            case 68: {
                double value = ((DoubleExpression)this.right).value;
                switch (this.type.getTypeCode()) {
                    case 1: {
                        return new ByteExpression(this.right.where, (byte)value);
                    }
                    case 2: {
                        return new CharExpression(this.right.where, (char)value);
                    }
                    case 3: {
                        return new ShortExpression(this.right.where, (short)value);
                    }
                    case 4: {
                        return new IntExpression(this.right.where, (int)value);
                    }
                    case 5: {
                        return new LongExpression(this.right.where, (long)value);
                    }
                    case 6: {
                        return new FloatExpression(this.right.where, (float)value);
                    }
                }
                break;
            }
        }
        return this;
    }

    @Override
    public boolean equals(int i) {
        return this.right.equals(i);
    }

    @Override
    public boolean equals(boolean b) {
        return this.right.equals(b);
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        if (this.right.type.inMask(1792) && this.type.inMask(1792)) {
            try {
                if (!env.implicitCast(this.right.type, this.type)) {
                    return this.inlineValue(env, ctx);
                }
            }
            catch (ClassNotFound e) {
                throw new CompilerError(e);
            }
        }
        return super.inline(env, ctx);
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.right.codeValue(env, ctx, asm);
        this.codeConversion(env, ctx, asm, this.right.type, this.type);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " " + this.type.toString() + " ");
        this.right.print(out);
        out.print(")");
    }
}

