/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreFactory;

public class SimpleDataStoreShell {
    DataStore<String, String> ds;
    ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    int counter = 0;

    public static void main(String[] args) throws Exception {
        DataStoreContext conf = new DataStoreContext();
        conf.setStoreName(args[0]).setInstanceName(args[1]).setGroupName(args[2]).setKeyClazz(String.class).setValueClazz(String.class).setClassLoader(ClassLoader.getSystemClassLoader()).setStartGMS(true).setDoAddCommands();
        new DataStoreFactory();
        DataStore<String, String> rds = DataStoreFactory.createDataStore(conf);
        SimpleDataStoreShell main = new SimpleDataStoreShell();
        main.runShell(rds);
    }

    private void runShell(DataStore<String, String> ds) {
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print(this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) {
        try {
            if ("put".equalsIgnoreCase(command)) {
                String key = params[0];
                this.ds.put(key, params[1]);
                System.out.println("PUT " + key);
                this.ds.put(key, params[1]);
            } else if ("get".equalsIgnoreCase(command)) {
                String value = this.ds.get(params[0]);
                System.out.println("get(" + params[0] + ") => " + value);
                if (value != null) {
                    this.cache.put(params[0], value);
                }
            } else if ("remove".equalsIgnoreCase(command)) {
                this.ds.remove(params[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class MyStoreable
    implements Storeable {
        private static final long serialVersionUID = 3735728171574889879L;
        long version;
        long accessTime;
        long maxIdleTime;
        String str1;
        String str2;
        boolean[] dirty = new boolean[2];

        public void touch() {
            ++this.version;
            this.accessTime = System.currentTimeMillis();
            this.maxIdleTime = 15000L;
        }

        public long _storeable_getVersion() {
            return this.version;
        }

        public String getStr1() {
            return this.str1;
        }

        public void setStr1(String str1) {
            boolean same;
            boolean bl = str1 != null ? str1.equals(this.str1) : (same = this.str1 == null);
            if (!same) {
                this.str1 = str1;
                this.dirty[0] = true;
            }
        }

        public String getStr2() {
            return this.str2;
        }

        public void setStr2(String str2) {
            boolean same;
            boolean bl = str2 != null ? str2.equals(this.str2) : (same = this.str2 == null);
            if (!same) {
                this.str2 = str2;
                this.dirty[1] = true;
            }
        }

        public void _storeable_setVersion(long version) {
            this.version = version;
        }

        public long _storeable_getLastAccessTime() {
            return this.maxIdleTime;
        }

        public void _storeable_setLastAccessTime(long accessTime) {
            this.accessTime = accessTime;
        }

        public long _storeable_getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void _storeable_setMaxIdleTime(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public String[] _storeable_getAttributeNames() {
            return new String[]{"str1", "str2"};
        }

        public boolean[] _storeable_getDirtyStatus() {
            return this.dirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _storeable_writeState(OutputStream os) throws IOException {
            DataOutputStream dos = null;
            try {
                dos = new DataOutputStream(os);
                dos.writeBoolean(this.dirty[0]);
                if (this.dirty[0]) {
                    dos.writeInt(this.str1 == null ? 0 : this.str1.length());
                    if (this.str1 != null) {
                        dos.write(this.str1.getBytes(Charset.defaultCharset()));
                    }
                }
                dos.writeBoolean(this.dirty[1]);
                if (this.dirty[1]) {
                    dos.writeInt(this.str2 == null ? 0 : this.str2.length());
                    if (this.str2 != null) {
                        dos.write(this.str2.getBytes());
                    }
                }
            }
            finally {
                try {
                    dos.flush();
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _storeable_readState(InputStream is) throws IOException {
            DataInputStream dis = null;
            try {
                byte[] strBytes;
                int strLen;
                dis = new DataInputStream(is);
                this.dirty[0] = dis.readBoolean();
                if (this.dirty[0] && (strLen = dis.readInt()) > 0) {
                    strBytes = new byte[strLen];
                    dis.read(strBytes);
                    this.str1 = new String(strBytes, Charset.defaultCharset());
                }
                this.dirty[1] = dis.readBoolean();
                if (this.dirty[1] && (strLen = dis.readInt()) > 0) {
                    strBytes = new byte[strLen];
                    dis.read(strBytes);
                    this.str2 = new String(strBytes);
                }
            }
            finally {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger("org.shoal.ha.cache").log(Level.FINEST, "Ignorable error while closing DataInputStream");
                }
            }
        }

        public String toString() {
            return "MyStoreable{version=" + this.version + ", accessTime=" + this.accessTime + ", maxIdleTime=" + this.maxIdleTime + ", str1='" + this.str1 + "', str2='" + this.str2 + "', dirty=" + Arrays.toString(this.dirty) + "}";
        }
    }
}

