/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.PortWatcher;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.util.CommandAction;
import com.sun.enterprise.util.HostAndPort;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domain")
@PerLookup
public class RestartDomainCommand
extends StopDomainCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    private boolean checkPidFile = true;
    @Param(name="check-process-alive", optional=true, defaultValue="true")
    private boolean checkProcessAlive;
    @Param(name="check-admin-port", optional=true, defaultValue="true")
    private boolean checkAdminEndpoint;
    @Param(name="server-output", shortName="o", optional=true)
    private Boolean printServerOutput;
    @Param(optional=true)
    private String customEndpoints;
    @Inject
    private ServiceLocator serviceLocator;

    @Override
    protected void doCommand() throws CommandException {
        if (!this.isRestartable()) {
            throw new CommandException("The domain reports that it is not restartable.\n\nThis usually means that the password file that was originally used to start the server has been deleted or is not readable now.\nPlease stop and then restart the server - or fix the password file.");
        }
        Long oldPid = this.getServerPid();
        HostAndPort oldAdminAddress = this.getReachableAdminAddress();
        boolean printDots = !this.programOpts.isTerse();
        PortWatcher portWatcher = oldAdminAddress == null ? null : PortWatcher.watch(oldAdminAddress, printDots);
        RemoteCLICommand cmd = new RemoteCLICommand("restart-domain", this.programOpts, this.env);
        if (this.debug == null) {
            cmd.executeAndReturnOutput(new String[]{"restart-domain"});
        } else {
            cmd.executeAndReturnOutput(new String[]{"restart-domain", "--debug", this.debug.toString()});
        }
        Duration timeout = this.getRestartTimeout();
        Duration startTimeout = this.isLocal() ? CommandAction.step(null, timeout, () -> this.waitForStop(oldPid, null, timeout)) : timeout;
        if (portWatcher != null && !portWatcher.get(startTimeout)) {
            logger.warning("The endpoint is still listening after timeout: " + String.valueOf(oldAdminAddress));
        }
        List<HostAndPort> userEndpoints = StartServerHelper.parseCustomEndpoints(this.customEndpoints);
        ServerLifeSignCheck lifeSignCheck = new ServerLifeSignCheck("domain " + this.getDomainName(), this.printServerOutput, this.checkPidFile, this.checkProcessAlive, this.checkAdminEndpoint, userEndpoints);
        Supplier<List<HostAndPort>> adminEndpointsSupplier = () -> List.of(this.getReachableAdminAddress());
        String report = this.waitForStart(oldPid, lifeSignCheck, adminEndpointsSupplier, startTimeout);
        logger.info(report);
    }

    @Override
    protected int dasNotRunning() throws CommandException {
        Duration startTimeout;
        if (!this.isLocal()) {
            throw new CommandException("Remote server is not running, can not restart it");
        }
        logger.warning("Server is not running, will attempt to start it...");
        CLICommand cmd = (CLICommand)this.serviceLocator.getService(CLICommand.class, "start-domain", new Annotation[0]);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-domain");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.domainDirParam != null) {
            opts.add("--domaindir");
            opts.add(this.domainDirParam);
        }
        if ((startTimeout = this.getStartTimeout()) != null) {
            opts.add("--timeout");
            opts.add(Long.toString(startTimeout.toSeconds()));
        }
        opts.add("--check-pid-file");
        opts.add(Boolean.toString(this.checkPidFile));
        opts.add("--check-process-alive");
        opts.add(Boolean.toString(this.checkProcessAlive));
        opts.add("--check-admin-port");
        opts.add(Boolean.toString(this.checkAdminEndpoint));
        if (this.printServerOutput != null) {
            opts.add("--server-output");
            opts.add(Boolean.toString(this.printServerOutput));
        }
        if (this.customEndpoints != null) {
            opts.add("--custom-endpoints");
            opts.add(this.customEndpoints);
        }
        if (this.getDomainName() != null) {
            opts.add(this.getDomainName());
        }
        return cmd.execute((String[])opts.toArray(String[]::new));
    }

    protected Duration getStartTimeout() {
        Duration parameter = this.getTimeout();
        return parameter == null ? CLIConstants.WAIT_FOR_DAS_TIME_MS : parameter;
    }

    private Duration getRestartTimeout() {
        Duration paramTimeout = this.getTimeout();
        if (paramTimeout != null) {
            return paramTimeout;
        }
        Duration startTimeout = this.getStartTimeout();
        if (startTimeout == null && CLIConstants.DEATH_TIMEOUT_MS == null) {
            return null;
        }
        if (startTimeout == null) {
            return CLIConstants.DEATH_TIMEOUT_MS.plusSeconds(5L);
        }
        if (CLIConstants.DEATH_TIMEOUT_MS == null) {
            return startTimeout.plusSeconds(5L);
        }
        return CLIConstants.WAIT_FOR_DAS_TIME_MS.plus(CLIConstants.DEATH_TIMEOUT_MS).plusSeconds(5L);
    }
}

