/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.security.SecurityUtil;

public class CoyoteInputStream
extends ServletInputStream {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    protected InputBuffer ib;

    public CoyoteInputStream(InputBuffer ib) {
        this.ib = ib;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ib = null;
    }

    public int read() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.readByte();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.available();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.available();
    }

    public int read(final byte[] b) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, 0, b.length);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, 0, b.length);
    }

    public int read(final byte[] b, final int off, final int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, off, len);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, off, len);
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        return super.readLine(b, off, len);
    }

    public boolean isFinished() {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        return this.ib.isFinished();
    }

    public boolean isReady() {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        return this.ib.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (readListener == null) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00042"));
        }
        this.ib.setReadListener(readListener);
    }

    public void close() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00041"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.ib.close();
        }
    }
}

