/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class SelectorFilter
implements Filter {
    private static boolean DEBUG = false;
    Selector selector = null;
    String selectorstr = null;

    public SelectorFilter(String selectorstr) throws SelectorFormatException {
        this.selectorstr = selectorstr;
        this.selector = Selector.compile((String)selectorstr);
    }

    public SelectorFilter(String selectorstr, Selector sel) {
        this.selectorstr = selectorstr;
        this.selector = sel;
    }

    public synchronized boolean matches(Object o) {
        if (this.selector == null) {
            return false;
        }
        if (o instanceof PacketReference) {
            PacketReference ref = (PacketReference)o;
            Hashtable props = null;
            HashMap headers = null;
            try {
                if (this.selector.usesProperties()) {
                    props = ref.getProperties();
                }
                if (this.selector.usesFields()) {
                    headers = ref.getHeaders();
                }
            }
            catch (ClassNotFoundException ex) {
                assert (false) : ref;
                throw new RuntimeException("error with properties", ex);
            }
            try {
                boolean match = this.selector.match((Map)props, (Map)headers);
                if (DEBUG && match) {
                    Globals.getLogger().log(4, "Match " + String.valueOf(o) + "against " + String.valueOf(this.selector) + " got " + match);
                }
                return match;
            }
            catch (SelectorFormatException ex) {
                Logger logger = Globals.getLogger();
                BrokerResources brokerResources = Globals.getBrokerResources();
                Globals.getBrokerResources();
                logger.logStack(32, brokerResources.getKString("B4487", this.selector, ex.getMessage()), (Throwable)ex);
                return false;
            }
        }
        assert (false) : " weird ";
        return false;
    }

    public String toString() {
        return "SelectorFilter[" + String.valueOf(this.selector) + "]" + this.hashCode();
    }
}

