/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.spi;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.ClassInfoReflectiveImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CurrentClassLoader;
import org.glassfish.pfl.dynamic.codegen.impl.Identifier;
import org.glassfish.pfl.dynamic.codegen.spi.ClassGenerator;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.MethodInfo;
import org.glassfish.pfl.dynamic.copyobject.spi.Immutable;

@Immutable
public class Type {
    private String name;
    private String packageName;
    private String className;
    private String signature;
    private int size;
    private Sort sort;
    private boolean isNumber;
    private int wideningNumber;
    private Type memberType;
    private ClassInfo classInfo;
    private Class<?> typeClass;
    private static ThreadLocal<Map<Class, Type>> classMap = new ThreadLocal<Map<Class, Type>>(){

        @Override
        public Map<Class, Type> initialValue() {
            return new WeakHashMap<Class, Type>();
        }
    };
    private static ThreadLocal<Map<String, Type>> classNameMap = new ThreadLocal<Map<String, Type>>(){

        @Override
        public Map<String, Type> initialValue() {
            return new WeakHashMap<String, Type>();
        }
    };
    private static Map<Class, Type> ptcToType = new HashMap<Class, Type>();
    private static final Type myVoid = new Type("void", "V", 0, false, Sort.PRIMITIVE, -1);
    private static final Type myNull = new Type("NULL", "N", 1, false, Sort.PRIMITIVE, -1);
    private static final Type myBoolean = new Type("boolean", "Z", 1, false, Sort.PRIMITIVE, -1);
    private static final Type myByte = new Type("byte", "B", 1, true, Sort.PRIMITIVE, 1);
    private static final Type myChar = new Type("char", "C", 1, true, Sort.PRIMITIVE, 2);
    private static final Type myShort = new Type("short", "S", 1, true, Sort.PRIMITIVE, 2);
    private static final Type myInt = new Type("int", "I", 1, true, Sort.PRIMITIVE, 3);
    private static final Type myLong = new Type("long", "J", 2, true, Sort.PRIMITIVE, 4);
    private static final Type myFloat = new Type("float", "F", 1, true, Sort.PRIMITIVE, 5);
    private static final Type myDouble = new Type("double", "D", 2, true, Sort.PRIMITIVE, 6);
    private static final Type myObject;
    private static final Type myString;
    private static final Type myClass;
    private static final Type myCloneable;

    private Type(String name, String signature, int size, boolean isNumber, Sort sort, int wideningNumber, Type memberType) {
        this.name = name;
        Pair<String, String> parts = Identifier.splitFQN(name);
        this.packageName = (String)parts.first();
        this.className = (String)parts.second();
        this.signature = signature;
        this.size = size;
        this.isNumber = isNumber;
        this.sort = sort;
        this.wideningNumber = wideningNumber;
        this.memberType = memberType;
        this.classInfo = null;
    }

    private Type(String name, String signature, int size, boolean isNumber, Sort sort, int wideningNumber) {
        this(name, signature, size, isNumber, sort, wideningNumber, null);
    }

    public static final void clearCaches() {
        classMap.get().clear();
        classNameMap.get().clear();
    }

    public static Type _array(Type memberType) {
        String name = memberType.name() + "[]";
        Type result = classNameMap.get().get(name);
        if (result == null) {
            result = new Type(name, "[" + memberType.signature, 1, false, Sort.ARRAY, -1, memberType);
            classNameMap.get().put(name, result);
        }
        return result;
    }

    public static Type _class(String name) {
        Type result = classNameMap.get().get(name);
        if (result == null) {
            result = new Type(name, "L" + name.replace('.', '/') + ";", 1, false, Sort.CLASS, -1);
            classNameMap.get().put(name, result);
        }
        return result;
    }

    public static Type _classGenerator(ClassGenerator cg) {
        Type result = Type._class(cg.name());
        result.classInfo = cg;
        return result;
    }

    private static boolean classIsStandard(Class cls) {
        String name = cls.getName();
        return name.startsWith("java.") || name.startsWith("javax.");
    }

    public static synchronized Type type(Class cls) {
        if (cls.isPrimitive()) {
            Type type = ptcToType.get(cls);
            assert (type != null);
            return type;
        }
        Type result = classMap.get().get(cls);
        if (result == null) {
            result = cls.isArray() ? Type._array(Type.type(cls.getComponentType())) : Type._class(cls.getName());
            result.typeClass = cls;
            classMap.get().put(cls, result);
            if (Type.classIsStandard(cls)) {
                classNameMap.get().put(cls.getName(), result);
            }
        }
        return result;
    }

    public static Type _void() {
        return myVoid;
    }

    public static Type _null() {
        return myNull;
    }

    public static Type _boolean() {
        return myBoolean;
    }

    public static Type _byte() {
        return myByte;
    }

    public static Type _char() {
        return myChar;
    }

    public static Type _short() {
        return myShort;
    }

    public static Type _int() {
        return myInt;
    }

    public static Type _long() {
        return myLong;
    }

    public static Type _float() {
        return myFloat;
    }

    public static Type _double() {
        return myDouble;
    }

    public static Type _Object() {
        return myObject;
    }

    public static Type _String() {
        return myString;
    }

    public static Type _Class() {
        return myClass;
    }

    public static Type _Cloneable() {
        return myCloneable;
    }

    public boolean isPrimitive() {
        return this.sort == Sort.PRIMITIVE;
    }

    public boolean isArray() {
        return this.sort == Sort.ARRAY;
    }

    public Type memberType() {
        if (this.isArray()) {
            return this.memberType;
        }
        throw new IllegalStateException("memberType() only valid for Array types");
    }

    public int size() {
        return this.size;
    }

    public String signature() {
        return this.signature;
    }

    public String name() {
        return this.name;
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public Class<?> getTypeClass() {
        if (this.typeClass == null) {
            try {
                this.typeClass = Class.forName(this.name, true, CurrentClassLoader.get());
            }
            catch (ClassNotFoundException cnfe) {
                IllegalArgumentException exc = new IllegalArgumentException("Cannot load class for type " + this.name);
                exc.initCause(cnfe);
                throw exc;
            }
            classMap.get().put(this.typeClass, this);
        }
        return this.typeClass;
    }

    public ClassInfo classInfo() {
        if (this.classInfo == null) {
            if (this.isArray()) {
                throw new IllegalStateException("Cannot get ClassInfo for array type " + this.name);
            }
            if (this.isPrimitive()) {
                throw new IllegalStateException("Cannot get ClassInfo for primitive type " + this.name);
            }
            this.classInfo = new ClassInfoReflectiveImpl(this);
        }
        return this.classInfo;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Type[" + this.name + "," + this.signature + "," + this.size + "," + this.sort + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Type other = (Type)Type.class.cast(obj);
        return this.signature.equals(other.signature);
    }

    public boolean hasPrimitiveNarrowingConversionFrom(Type t) {
        if (this.isPrimitive()) {
            if (!t.isPrimitive()) {
                return false;
            }
            if (this.wideningNumber < 0 || t.wideningNumber < 0) {
                return false;
            }
            if (t == myByte) {
                return this == myChar;
            }
            if (t == this) {
                return false;
            }
            return t.wideningNumber >= this.wideningNumber;
        }
        return false;
    }

    public boolean hasPrimitiveWideningConversionFrom(Type t) {
        if (this.isPrimitive()) {
            if (!t.isPrimitive()) {
                return false;
            }
            if (this.wideningNumber < 0 || t.wideningNumber < 0) {
                return false;
            }
            if (t == myByte && this == myChar) {
                return false;
            }
            return t.wideningNumber < this.wideningNumber;
        }
        return false;
    }

    private boolean returnTypeCollision(Set<MethodInfo> set1, Set<MethodInfo> set2) {
        for (MethodInfo mi1 : set1) {
            for (MethodInfo mi2 : set2) {
                if (!mi1.signature().equals(mi2.signature()) || mi1.returnType().equals(mi2.returnType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean noMethodConflicts(Type t1, Type t2) {
        ClassInfo c1 = null;
        ClassInfo c2 = null;
        c1 = t1.classInfo();
        c2 = t2.classInfo();
        for (String name : c1.methodInfoByName().keySet()) {
            Set<MethodInfo> set2;
            Set<MethodInfo> set1;
            if (!c2.methodInfoByName().containsKey(name) || !this.returnTypeCollision(set1 = c1.methodInfoByName().get(name), set2 = c2.methodInfoByName().get(name))) continue;
            return false;
        }
        return true;
    }

    private boolean isSubclass(Type t) {
        return this.classInfo().isSubclass(t.classInfo());
    }

    private boolean isInterface() {
        if (this.isArray() || this.isPrimitive()) {
            return false;
        }
        return this.classInfo().isInterface();
    }

    private int modifiers() {
        return this.classInfo().modifiers();
    }

    public boolean hasReferenceNarrowingConversionFrom(Type t) {
        if (this.isPrimitive() || t.isPrimitive()) {
            return false;
        }
        if (t.equals(Type._Object())) {
            return true;
        }
        if (t.isInterface()) {
            if (this.isArray()) {
                return false;
            }
            if (!this.isInterface()) {
                if (!Modifier.isFinal(this.modifiers())) {
                    return true;
                }
                if (this.isSubclass(t)) {
                    return true;
                }
            } else if (!t.isSubclass(this) && this.noMethodConflicts(t, this)) {
                return true;
            }
        } else {
            if (t.isArray()) {
                if (this.isArray()) {
                    return this.memberType().hasReferenceNarrowingConversionFrom(t.memberType);
                }
                return false;
            }
            if (this.isArray()) {
                return false;
            }
            if (this.isSubclass(t)) {
                return true;
            }
            if (!(this.isInterface() || Modifier.isFinal(t.modifiers()) || t.isSubclass(this))) {
                return true;
            }
        }
        return false;
    }

    public boolean hasReferenceWideningConversionFrom(Type t) {
        if (this.isPrimitive() || t.isPrimitive()) {
            return false;
        }
        if (this.equals(Type._Object())) {
            return true;
        }
        if (t.equals(Type._null())) {
            return true;
        }
        if (t.isArray()) {
            if (this.equals(myCloneable)) {
                return true;
            }
            if (this.isArray() && !this.memberType().isPrimitive()) {
                return this.memberType().isMethodInvocationConvertibleFrom(t.memberType());
            }
            return false;
        }
        if (this.isArray()) {
            return false;
        }
        return t.isSubclass(this);
    }

    public boolean isAssignmentConvertibleFrom(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (this.hasPrimitiveWideningConversionFrom(t)) {
            return true;
        }
        return this.hasReferenceWideningConversionFrom(t);
    }

    public boolean isCastingConvertibleFrom(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (this.hasPrimitiveWideningConversionFrom(t)) {
            return true;
        }
        if (this.hasReferenceWideningConversionFrom(t)) {
            return true;
        }
        if (this.hasPrimitiveNarrowingConversionFrom(t)) {
            return true;
        }
        return this.hasReferenceNarrowingConversionFrom(t);
    }

    public Type unaryPromotion() {
        if (!this.isNumber()) {
            throw new IllegalArgumentException("Only number types have unary promotions");
        }
        if (this.equals(Type._byte())) {
            return Type._int();
        }
        if (this.equals(Type._short())) {
            return Type._int();
        }
        if (this.equals(Type._char())) {
            return Type._int();
        }
        return this;
    }

    public Type binaryPromotion(Type t) {
        if (!this.isNumber() || !t.isNumber()) {
            throw new IllegalArgumentException("Only number types have binary promotions");
        }
        if (this.equals(Type._double()) || t.equals(Type._double())) {
            return Type._double();
        }
        if (this.equals(Type._float()) || t.equals(Type._float())) {
            return Type._float();
        }
        if (this.equals(Type._long()) || t.equals(Type._long())) {
            return Type._long();
        }
        return Type._int();
    }

    public boolean isMethodInvocationConvertibleFrom(Type t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.equals(t)) {
            return true;
        }
        if (this.isPrimitive()) {
            return this.hasPrimitiveWideningConversionFrom(t);
        }
        return this.hasReferenceWideningConversionFrom(t);
    }

    static {
        ptcToType.put(Boolean.TYPE, myBoolean);
        ptcToType.put(Byte.TYPE, myByte);
        ptcToType.put(Character.TYPE, myChar);
        ptcToType.put(Short.TYPE, myShort);
        ptcToType.put(Integer.TYPE, myInt);
        ptcToType.put(Long.TYPE, myLong);
        ptcToType.put(Float.TYPE, myFloat);
        ptcToType.put(Double.TYPE, myDouble);
        ptcToType.put(Void.TYPE, myVoid);
        ptcToType = Collections.unmodifiableMap(ptcToType);
        myObject = Type._class("java.lang.Object");
        myString = Type._class("java.lang.String");
        myClass = Type._class("java.lang.Class");
        myCloneable = Type._class("java.lang.Cloneable");
    }

    static enum Sort {
        PRIMITIVE,
        ARRAY,
        CLASS;

    }
}

