/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.util.ServletContextUtil;
import com.sun.xml.wss.util.WSSServletContextFacade;
import com.sun.xml.xwss.SecurityConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConstants;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWSSServerTube
extends AbstractFilterTubeImpl {
    protected static final String FAILURE = "com.sun.xml.ws.shd.failure";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String CONTEXT_WSDL_OPERATION = "com.sun.xml.ws.wsdl.operation";
    private final WSEndpoint endPoint;
    private final WSDLPort port;
    private SecurityConfiguration config;
    protected SOAPFactory soapFactory;
    protected MessageFactory messageFactory;
    protected SOAPVersion soapVersion;
    protected boolean isSOAP12;
    private static final String ENCRYPTED_BODY_QNAME = "{http://www.w3.org/2001/04/xmlenc#}EncryptedData";

    public XWSSServerTube(WSEndpoint epoint, WSDLPort prt, Tube nextTube) {
        super(nextTube);
        this.endPoint = epoint;
        this.port = prt;
        try {
            this.config = new SecurityConfiguration(this.getServerConfig());
        }
        catch (XWSSecurityException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        this.soapVersion = this.endPoint.getBinding().getSOAPVersion();
        this.isSOAP12 = this.soapVersion == SOAPVersion.SOAP_12;
        this.soapFactory = this.soapVersion.getSOAPFactory();
        this.messageFactory = this.soapVersion.getMessageFactory();
    }

    public XWSSServerTube(XWSSServerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.endPoint = that.endPoint;
        this.port = that.port;
        this.soapFactory = that.soapFactory;
        this.messageFactory = that.messageFactory;
        this.soapVersion = that.soapVersion;
        this.isSOAP12 = that.isSOAP12;
        this.config = that.config;
    }

    @Override
    public void preDestroy() {
    }

    private InputStream getServerConfigStream() {
        QName serviceQName = this.endPoint.getServiceName();
        String serviceName = serviceQName.getLocalPart();
        Object serverConfig = "/WEB-INF/" + serviceName + "_security_config.xml";
        ServletContext context = this.endPoint.getContainer().getSPI(ServletContext.class);
        if (context == null) {
            return null;
        }
        InputStream in = context.getResourceAsStream((String)serverConfig);
        if (in == null) {
            serverConfig = "/WEB-INF/server_security_config.xml";
            in = context.getResourceAsStream((String)serverConfig);
        }
        return in;
    }

    private URL getServerConfig() {
        QName serviceQName = this.endPoint.getServiceName();
        String serviceName = serviceQName.getLocalPart();
        WSSServletContextFacade ctxt = ServletContextUtil.getServletContextFacade(this.endPoint);
        String serverName = "server";
        URL url = null;
        if (ctxt != null) {
            String serverConfig = "/WEB-INF/" + serverName + "_security_config.xml";
            url = ctxt.getResource(serverConfig);
            if (url == null) {
                serverConfig = "/WEB-INF/" + serviceName + "_security_config.xml";
                url = ctxt.getResource(serverConfig);
            }
            return url;
        }
        String serverConfig = "META-INF/" + serverName + "_security_config.xml";
        url = SecurityUtil.loadFromClasspath(serverConfig);
        if (url == null) {
            serverConfig = "META-INF/" + serviceName + "_security_config.xml";
            url = SecurityUtil.loadFromClasspath(serverConfig);
        }
        return url;
    }

    public Packet validateRequest(Packet packet) throws Exception {
        if (this.config == null) {
            return packet;
        }
        ProcessingContextImpl context = null;
        SOAPMessage message = packet.getMessage().readAsSOAPMessage();
        try {
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext(packet));
            context = new ProcessingContextImpl(packet.invocationProperties);
            context.setSOAPMessage(message);
            String operation = this.getOperationName(message);
            ApplicationSecurityConfiguration _sConfig = this.config.getSecurityConfiguration();
            if (operation.equals(ENCRYPTED_BODY_QNAME) && _sConfig.hasOperationPolicies()) {
                ApplicationSecurityConfiguration appconfig = (ApplicationSecurityConfiguration)_sConfig.getSecurityPolicies(sContext).next();
                if (appconfig != null) {
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(appconfig);
                } else {
                    ApplicationSecurityConfiguration config0 = (ApplicationSecurityConfiguration)_sConfig.getAllTopLevelApplicationSecurityConfigurations().iterator().next();
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(config0);
                }
            } else {
                sContext.setOperationIdentifier(operation);
                packet.invocationProperties.put(CONTEXT_WSDL_OPERATION, operation);
                SecurityPolicy policy = _sConfig.getSecurityConfiguration(sContext);
                context.setPolicyContext(sContext);
                if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                    context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
                } else {
                    context.setSecurityPolicy(policy);
                }
            }
            context.setSecurityEnvironment(this.config.getSecurityEnvironment());
            context.isInboundMessage(true);
            if (_sConfig.retainSecurityHeader()) {
                context.retainSecurityHeader(true);
            }
            if (_sConfig.resetMustUnderstand()) {
                context.resetMustUnderstand(true);
            }
            SecurityRecipient.validateMessage(context);
            String operationName = this.getOperationName(message);
            packet.invocationProperties.put(CONTEXT_WSDL_OPERATION, operationName);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (WssSoapFaultException soapFaultException) {
            packet.invocationProperties.put(FAILURE, TRUE);
            this.addFault(soapFaultException, message, this.isSOAP12);
            packet.setMessage(Messages.create(message));
            return packet;
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            packet.invocationProperties.put(FAILURE, TRUE);
            this.addFault(wsfe, message, this.isSOAP12);
            packet.setMessage(Messages.create(message));
            return packet;
        }
    }

    public Packet secureResponse(Packet packet) throws Exception {
        if (this.config == null) {
            return packet;
        }
        try {
            ProcessingContextImpl context = new ProcessingContextImpl(packet.invocationProperties);
            String operation = (String)packet.invocationProperties.get(CONTEXT_WSDL_OPERATION);
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext(packet));
            sContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration _sConfig = this.config.getSecurityConfiguration();
            SecurityPolicy policy = _sConfig.getSecurityConfiguration(sContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(this.config.getSecurityEnvironment());
            context.isInboundMessage(false);
            context.setSOAPMessage(packet.getMessage().readAsSOAPMessage());
            SecurityAnnotator.secureMessage(context);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (WssSoapFaultException soapFaultException) {
            Message msg = Messages.create(this.getSOAPFault(soapFaultException));
            packet.setMessage(msg);
            return packet;
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            Message msg = Messages.create(this.getSOAPFault(wsfe));
            packet.setMessage(msg);
            return packet;
        }
    }

    private StaticApplicationContext getPolicyContext(Packet packet) {
        ApplicationSecurityConfiguration appconfig = this.config.getSecurityConfiguration();
        StaticApplicationContext iContext = (StaticApplicationContext)appconfig.getAllContexts().next();
        StaticApplicationContext sContext = new StaticApplicationContext(iContext);
        QName portQname = null;
        if (this.port != null) {
            portQname = this.port.getName();
        }
        String prt = null;
        prt = portQname == null ? "" : portQname.toString();
        sContext.setPortIdentifier(prt);
        return sContext;
    }

    public void addFault(WssSoapFaultException sfe, SOAPMessage soapMessage, boolean isSOAP12) throws SOAPException {
        SOAPBody body = soapMessage.getSOAPBody();
        body.removeContents();
        soapMessage.removeAllAttachments();
        QName faultCode = sfe.getFaultCode();
        Object faultCodeName = null;
        if (faultCode == null) {
            faultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
        }
        if (isSOAP12) {
            SOAPFault fault = body.addFault(SOAPConstants.SOAP_SENDER_FAULT, sfe.getMessage());
            fault.appendFaultSubcode(faultCode);
        } else {
            body.addFault(faultCode, sfe.getMessage());
        }
        NodeList list = soapMessage.getSOAPPart().getEnvelope().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (list.getLength() > 0) {
            Node node = list.item(0);
            node.getParentNode().removeChild(node);
        }
    }

    protected SOAPFault getSOAPFault(WssSoapFaultException sfe) {
        SOAPFault fault = null;
        try {
            if (this.isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Security Pipe: Internal Error while trying to create a SOAPFault");
        }
        return fault;
    }

    public SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe, boolean isSOAP12) {
        SOAPFault fault = null;
        try {
            if (isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(this) + ": Internal Error while trying to create a SOAPFault");
        }
        return new SOAPFaultException(fault);
    }

    private String getOperationName(SOAPMessage message) throws Exception {
        Node node = null;
        Object key = null;
        SOAPBody body = null;
        if (message == null) {
            throw new XWSSecurityException("SOAPMessage in message context is null");
        }
        body = message.getSOAPBody();
        if (body == null) {
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        StringBuilder tmp = new StringBuilder();
        String operation = "";
        for (node = body.getFirstChild(); node != null; node = node.getNextSibling()) {
            tmp.append("{").append(node.getNamespaceURI()).append("}").append(node.getLocalName()).append(":");
        }
        operation = tmp.toString();
        if (operation.length() > 0) {
            return operation.substring(0, operation.length() - 1);
        }
        return operation;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new XWSSServerTube(this, cloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        try {
            Packet ret = this.validateRequest(packet);
            if (TRUE.equals(ret.invocationProperties.get(FAILURE))) {
                return this.doReturnWith(ret);
            }
            return this.doInvoke(this.next, ret);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
    }

    @Override
    public NextAction processResponse(Packet ret) {
        try {
            if (ret.getMessage() == null) {
                return this.doReturnWith(ret);
            }
            Packet response = this.secureResponse(ret);
            return this.doReturnWith(response);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
    }
}

