/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.validation;

import com.sun.messaging.jmq.jmsclient.validation.XMLValidator;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ValidatorFactory {
    static final String TOPIC_PROP_NAME_PREFIX = "imq.xml.validate.topic";
    static final String QUEUE_PROP__NAME_PREFIX = "imq.xml.validate.queue";

    protected ValidatorFactory() {
    }

    public static ValidatorFactory newInstance() {
        return new ValidatorFactory();
    }

    public static XMLValidator newValidator() throws JMSException {
        return new XMLValidator();
    }

    public static XMLValidator newValidator(String xsdURIList) throws JMSException {
        return new XMLValidator(xsdURIList);
    }

    public static XMLValidator newValidator(String schemaLang, String xsdURIList) throws JMSException {
        return new XMLValidator(schemaLang, xsdURIList);
    }

    public static Hashtable getTopicValidateTable() {
        return ValidatorFactory.getValidateTable(TOPIC_PROP_NAME_PREFIX);
    }

    public static Hashtable getQueueValidateTable() {
        return ValidatorFactory.getValidateTable(QUEUE_PROP__NAME_PREFIX);
    }

    private static Hashtable getValidateTable(String prefix) {
        Hashtable<String, XMLValidator> table = new Hashtable<String, XMLValidator>();
        try {
            Properties props = System.getProperties();
            Enumeration<Object> enum2 = props.keys();
            while (enum2.hasMoreElements()) {
                String name = (String)enum2.nextElement();
                if (!name.startsWith(prefix)) continue;
                int fromIndex = prefix.length() + 1;
                int endIndex = name.indexOf(46, fromIndex);
                String topicName = name.substring(fromIndex, endIndex);
                String uri = System.getProperty(name);
                XMLValidator validator = null;
                validator = uri.length() > 4 ? ValidatorFactory.newValidator(uri) : ValidatorFactory.newValidator();
                table.put(topicName, validator);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }
}

