/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.cdi.transaction.TransactionScopedBean;
import org.glassfish.cdi.transaction.TransactionScopedCDIUtil;

public class TransactionScopedContextImpl
implements Context {
    public static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";
    ConcurrentHashMap<TransactionSynchronizationRegistry, Set<TransactionScopedBean<?>>> beansPerTransaction = new ConcurrentHashMap();

    public ConcurrentHashMap<TransactionSynchronizationRegistry, Set<TransactionScopedBean<?>>> getBeansPerTransaction() {
        return this.beansPerTransaction;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = this.getTransactionSynchronizationRegistry();
        Object beanId = this.getContextualId(contextual);
        T contextualInstance = this.getContextualInstance(beanId, transactionSynchronizationRegistry);
        if (contextualInstance == null) {
            contextualInstance = this.createContextualInstance(contextual, beanId, creationalContext, transactionSynchronizationRegistry);
        }
        return contextualInstance;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.getContextualInstance(this.getContextualId(contextual), this.getTransactionSynchronizationRegistry());
    }

    public boolean isActive() {
        try {
            this.getTransactionSynchronizationRegistry();
            return true;
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return false;
        }
    }

    private Object getContextualId(Contextual<?> contextual) {
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)contextual;
            return passivationCapable.getId();
        }
        return contextual;
    }

    private <T> T createContextualInstance(Contextual<T> contextual, Object contextualId, CreationalContext<T> creationalContext, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        TransactionScopedBean<T> transactionScopedBean = new TransactionScopedBean<T>(contextual, creationalContext, this);
        transactionSynchronizationRegistry.putResource(contextualId, transactionScopedBean);
        transactionSynchronizationRegistry.registerInterposedSynchronization(transactionScopedBean);
        Set<TransactionScopedBean<Object>> transactionScopedBeanSet = this.beansPerTransaction.get(transactionSynchronizationRegistry);
        if (transactionScopedBeanSet != null) {
            transactionScopedBeanSet = Collections.synchronizedSet(transactionScopedBeanSet);
        } else {
            transactionScopedBeanSet = Collections.synchronizedSet(new HashSet());
            TransactionScopedCDIUtil.fireEvent("INITIALIZED_EVENT");
            this.beansPerTransaction.put(transactionSynchronizationRegistry, transactionScopedBeanSet);
        }
        transactionScopedBeanSet.add(transactionScopedBean);
        return transactionScopedBean.getContextualInstance();
    }

    private <T> T getContextualInstance(Object beanId, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object obj = transactionSynchronizationRegistry.getResource(beanId);
        TransactionScopedBean transactionScopedBean = (TransactionScopedBean)obj;
        if (transactionScopedBean != null) {
            return transactionScopedBean.getContextualInstance();
        }
        return null;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        try {
            transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)new InitialContext().lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_JNDI_NAME);
        }
        catch (NamingException ne) {
            throw new ContextNotActiveException("Could not get TransactionSynchronizationRegistry", (Throwable)ne);
        }
        int status = transactionSynchronizationRegistry.getTransactionStatus();
        if (status == 0 || status == 1 || status == 2 || status == 5 || status == 7 || status == 8 || status == 9) {
            return transactionSynchronizationRegistry;
        }
        throw new ContextNotActiveException("TransactionSynchronizationRegistry status is not active.");
    }
}

