/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable.archive;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.glassfish.embeddable.archive.Assembler;

public class ScatteredArchive {
    private static System.Logger logger = System.getLogger(ScatteredArchive.class.getName());
    static final String JAVA_CLASS_PATH_PROPERTY_KEY = "java.class.path";
    String name;
    Type type;
    File rootDirectory;
    List<File> classpaths = new ArrayList<File>();
    Map<String, File> metadatas = new HashMap<String, File>();
    String metadataEntryPrefix;

    public ScatteredArchive(String name, Type type) {
        if (name == null) {
            throw new NullPointerException("name must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null.");
        }
        this.name = name;
        this.type = type;
        this.metadataEntryPrefix = type == Type.WAR ? "WEB-INF/" : "META-INF/";
    }

    public ScatteredArchive(String name, Type type, File rootDirectory) throws IOException {
        this(name, type);
        if (rootDirectory == null) {
            throw new NullPointerException("rootDirectory must not be null.");
        }
        if (!rootDirectory.exists()) {
            throw new IOException(String.valueOf(rootDirectory) + " does not exist.");
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(rootDirectory) + " is not a directory.");
        }
        this.rootDirectory = rootDirectory;
    }

    public void addClassPath(File classpath) throws IOException {
        if (classpath == null) {
            throw new NullPointerException("classpath must not be null.");
        }
        if (!classpath.exists()) {
            throw new IOException(String.valueOf(classpath) + " does not exist.");
        }
        this.classpaths.add(classpath);
    }

    public void addCurrentClassPath(String ... excludePatterns) {
        this.addCurrentClassPath((String path) -> {
            String fileName = new File((String)path).getName();
            return ScatteredArchive.fileNameMatchesAny(fileName, excludePatterns) || ScatteredArchive.fileNameMatchesAny(fileName, "jakarta\\..*\\.jar", "glassfish-embedded-.*\\.jar");
        });
    }

    public void addCurrentClassPath(Predicate<String> exclude) {
        String classpath = System.getProperty(JAVA_CLASS_PATH_PROPERTY_KEY, "");
        if (classpath.isBlank()) {
            return;
        }
        for (String pathElem : classpath.split(File.pathSeparator)) {
            if (exclude.test(pathElem)) continue;
            try {
                this.addClassPath(new File(pathElem));
            }
            catch (IOException ex) {
                logger.log(System.Logger.Level.WARNING, () -> "Could not add " + pathElem + " to the classpath: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static boolean fileNameMatchesAny(String fileName, String ... matches) {
        for (String match : matches) {
            if (!fileName.matches(match)) continue;
            return true;
        }
        return false;
    }

    public void addMetadata(File metadata) throws IOException {
        this.addMetadata(metadata, null);
    }

    public void addMetadata(File metadata, String name) throws IOException {
        if (metadata == null) {
            throw new NullPointerException("metadata must not be null.");
        }
        if (!metadata.exists()) {
            throw new IOException(String.valueOf(metadata) + " does not exist.");
        }
        if (metadata.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(metadata) + " is a directory.");
        }
        if (name == null) {
            name = this.metadataEntryPrefix + metadata.getName();
        }
        this.metadatas.put((String)name, metadata);
    }

    public URI toURI() throws IOException {
        return new Assembler().assemble(this);
    }

    public static enum Type {
        JAR,
        WAR,
        RAR;

    }
}

