/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.DumpUtils;
import com.sun.xml.ws.transport.tcp.util.SelectorFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OutputWriter {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.dump");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            Socket socket = socketChannel.socket();
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1070_OUTPUT_WRITER_DUMP(socket.getInetAddress().getHostAddress(), socketChannel.socket().getPort()));
            logger.log(Level.FINEST, DumpUtils.dumpBytes(bb));
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        try {
            while (bb.hasRemaining()) {
                int len = socketChannel.write(bb);
                ++attempts;
                if (len < 0) {
                    throw new EOFException();
                }
                if (len == 0) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(30000L) == 0) {
                        if (attempts <= 2) continue;
                        Socket socket = socketChannel.socket();
                        throw new IOException(MessagesMessages.WSTCP_0019_PEER_DISCONNECTED(socket.getInetAddress().getHostAddress(), socketChannel.socket().getPort()));
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            Socket socket = socketChannel.socket();
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1070_OUTPUT_WRITER_DUMP(socket.getInetAddress().getHostAddress(), socketChannel.socket().getPort()));
            logger.log(Level.FINEST, DumpUtils.dumpBytes(bb));
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        try {
            while (OutputWriter.hasRemaining(bb)) {
                long len = socketChannel.write(bb);
                ++attempts;
                if (len < 0L) {
                    throw new EOFException();
                }
                if (len == 0L) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(30000L) == 0) {
                        if (attempts <= 2) continue;
                        Socket socket = socketChannel.socket();
                        throw new IOException(MessagesMessages.WSTCP_0019_PEER_DISCONNECTED(socket.getInetAddress().getHostAddress(), socketChannel.socket().getPort()));
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
    }

    private static boolean hasRemaining(ByteBuffer[] bb) {
        for (int i = bb.length - 1; i >= 0; --i) {
            if (!bb[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }
}

