/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ServerInfo;

public class ApplicationContext
implements ServletContext {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final HashMap<String, String> readOnlyAttributes = new HashMap();
    private final Object attributesLock = new Object();
    private final StandardContext context;
    private final ServletContext facade = new ApplicationContextFacade(this);
    private final ConcurrentMap<String, String> parameters = new ConcurrentHashMap<String, String>();
    private boolean isRestricted;

    public ApplicationContext(StandardContext context) {
        this.context = context;
        this.setAttribute("com.sun.faces.useMyFaces", context.isUseMyFaces());
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    @Override
    public String getContextPath() {
        return this.context.getPath();
    }

    @Override
    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    @Override
    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return new Enumerator<String>(this.parameters.keySet());
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.parameters.putIfAbsent(name, value) == null;
    }

    @Override
    public int getMajorVersion() {
        return 6;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    @Override
    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    @Override
    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    @Override
    public void log(String message) {
        this.context.log(message);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Object value = null;
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            value = this.attributes.remove(name);
            if (value == null) {
                return;
            }
        }
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                log.log(Level.WARNING, "AS-WEB-CORE-00084", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        if (name == null) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00085"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        if (name.equals("org.apache.catalina.jsp_classpath") || name.equals("com.sun.jsp.tldUriToLocationMap")) {
            this.setAttributeReadOnly(name);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                log.log(Level.WARNING, "AS-WEB-CORE-00084", t);
            }
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, className);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, servlet);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, servletClass);
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addJspFile(servletName, jspFile);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createServlet(clazz);
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getServletRegistration(servletName);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getServletRegistrations();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, className);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, filter);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, filterClass);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createFilter(clazz);
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getFilterRegistration(filterName);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getFilterRegistrations();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getSessionCookieConfig();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    @Override
    public void addListener(String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(className);
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(t);
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(listenerClass);
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createListener(clazz);
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    @Override
    public void declareRoles(String ... roleNames) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.declareRoles(roleNames);
    }

    @Override
    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    @Override
    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setSessionTimeout(sessionTimeout);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setRequestCharacterEncoding(encoding);
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setResponseCharacterEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAttributes() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = this.attributesLock;
        synchronized (iterator) {
            for (String element : this.attributes.keySet()) {
                list.add(element);
            }
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeReadOnly(String name) {
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    void setRestricted(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    public String toString() {
        return super.toString() + "[context=" + String.valueOf(this.context) + "]";
    }
}

