/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.Subject;
import org.glassfish.exousia.modules.locked.SimplePolicyConfiguration;

public class SimplePolicyProvider
implements Policy {
    private static final System.Logger LOG = System.getLogger(SimplePolicyProvider.class.getName());
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private static ThreadLocal<Object> reentrancyStatus = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permissionToBeChecked, Subject subject) {
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            return true;
        }
        alreadyCalled[0] = 1;
        try {
            boolean bl = this.doImplies(permissionToBeChecked, subject);
            return bl;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    private boolean doImplies(Permission permissionToBeChecked, Subject subject) {
        int implies = 1;
        try {
            implies = SimplePolicyConfiguration.implies(permissionToBeChecked, subject);
            if (implies > 0) {
                LOG.log(System.Logger.Level.TRACE, "SimplePolicyConfiguration returned implies = {0}, returning true.", implies);
                return true;
            }
        }
        catch (PolicyContextException e) {
            LOG.log(System.Logger.Level.TRACE, "SimplePolicyConfiguration.implies failed.", (Throwable)e);
        }
        LOG.log(System.Logger.Level.DEBUG, "Access refused for the policy context id {0}, permission {1} and subject {2}.", PolicyContext.getContextID(), permissionToBeChecked, subject);
        return false;
    }

    public void refresh() {
        try {
            boolean supportsReuse;
            String propValue = System.getProperty(REUSE);
            boolean bl = supportsReuse = propValue == null ? true : Boolean.parseBoolean(propValue);
            if (supportsReuse && PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
            SimplePolicyConfiguration.refresh();
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException("Refresh failed", pce);
        }
    }

    public PermissionCollection getPermissionCollection(Subject subject) {
        return null;
    }

    public boolean impliesByRole(Permission permissionToBeChecked, Subject subject) {
        return false;
    }

    public boolean isExcluded(Permission permissionToBeChecked) {
        return false;
    }

    public boolean isUnchecked(Permission permissionToBeChecked) {
        return false;
    }
}

