/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.glassfish.exousia.constraints.transformer.ConstraintValue;

public class MethodValue
extends ConstraintValue {
    private static final List<String> methodNames = new ArrayList<String>();
    int index;

    MethodValue(String methodName) {
        this.index = MethodValue.getMethodIndex(methodName);
    }

    MethodValue(String methodName, ConstraintValue constraint) {
        this.index = MethodValue.getMethodIndex(methodName);
        this.setValue(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMethodName(int index) {
        List<String> list = methodNames;
        synchronized (list) {
            return methodNames.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getMethodIndex(String name) {
        List<String> list = methodNames;
        synchronized (list) {
            int index = methodNames.indexOf(name);
            if (index < 0) {
                index = methodNames.size();
                methodNames.add(index, name);
            }
            return index;
        }
    }

    static String getActions(BitSet methodSet) {
        if (methodSet == null || methodSet.isEmpty()) {
            return null;
        }
        StringBuilder actions = null;
        int i = methodSet.nextSetBit(0);
        while (i >= 0) {
            if (actions == null) {
                actions = new StringBuilder();
            } else {
                actions.append(",");
            }
            actions.append(MethodValue.getMethodName(i));
            i = methodSet.nextSetBit(i + 1);
        }
        return actions == null ? null : actions.toString();
    }

    static BitSet encodeMethodsToBits(Collection<String> methods) {
        BitSet methodSet = new BitSet();
        for (String method : methods) {
            if (method == null) {
                throw new IllegalArgumentException("constraint translation error - null method name");
            }
            methodSet.set(MethodValue.getMethodIndex(method));
        }
        return methodSet;
    }

    @Override
    public String toString() {
        return "MethodValue( " + MethodValue.getMethodName(this.index) + super.toString() + " )";
    }
}

