/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventBroadcastHelper
implements EventBroadcaster {
    private List<ListenerInfo>[] collectionArray = new List[EventType.EVENT_TYPE_NUM];
    private boolean[] busy = new boolean[EventType.EVENT_TYPE_NUM];
    private int[] start = null;
    private int cnt = 0;
    private Boolean orderMaintained = true;
    private final Object orderMaintainedLock = new Object();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock shareLock = this.lock.readLock();
    private final Lock exclusiveLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderMaintained(boolean order) {
        Object object = this.orderMaintainedLock;
        synchronized (object) {
            this.orderMaintained = order;
            if (!this.orderMaintained.booleanValue()) {
                this.start = new int[EventType.EVENT_TYPE_NUM];
            }
        }
    }

    public void clear() {
        this.exclusiveLock.lock();
        try {
            this.collectionArray = new List[EventType.EVENT_TYPE_NUM];
            for (int i = 0; i < EventType.EVENT_TYPE_NUM; ++i) {
                this.busy[i] = false;
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    public void dump(PrintStream ps) {
        ps.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("EventBroadcastHelper {\n");
        this.shareLock.lock();
        try {
            str.append("\tcnt=").append(this.cnt).append('\n');
            int len = this.collectionArray.length;
            for (int i = 0; i < len; ++i) {
                boolean indent = false;
                str.append('\t').append(i).append("busy[").append(i).append("]=").append(this.busy[i]).append(" { ");
                if (this.collectionArray[i] == null) {
                    str.append("null");
                } else {
                    Iterator<ListenerInfo> itr = this.collectionArray[i].iterator();
                    boolean first = true;
                    int indx = 0;
                    while (itr.hasNext()) {
                        ListenerInfo li = itr.next();
                        indent = true;
                        if (!first) {
                            str.append("\t    ");
                        }
                        first = false;
                        str.append(indx).append(":  ").append(li.getListener()).append("\n\t        ").append((Object)li.getType()).append("\n\t        ").append(li.getReason()).append("\n\t        ").append(li.getUserData()).append('\n');
                        ++indx;
                    }
                }
                if (indent) {
                    str.append("\t  }\n");
                    continue;
                }
                str.append(" }\n");
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return str.toString();
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) {
        return this.addEventListener(listener, type, null, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) {
        ListenerInfo li = new ListenerInfo(listener, type, reason, userData);
        int indx = type.getEvent();
        this.exclusiveLock.lock();
        try {
            if (this.collectionArray[indx] == null) {
                this.collectionArray[indx] = new ArrayList<ListenerInfo>();
                this.collectionArray[indx].add(li);
            } else {
                ArrayList<ListenerInfo> ls = new ArrayList<ListenerInfo>(this.collectionArray[indx]);
                ls.add(li);
                this.collectionArray[indx] = ls;
            }
            this.busy[indx] = true;
            ++this.cnt;
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeEventListener(Object id) {
        this.exclusiveLock.lock();
        try {
            if (id == null) {
                Object var2_2 = null;
                return var2_2;
            }
            ListenerInfo li = (ListenerInfo)id;
            if (!li.isValid()) {
                Object var3_4 = null;
                return var3_4;
            }
            int indx = li.getType().getEvent();
            List<ListenerInfo> s = this.collectionArray[indx];
            if (s == null) {
                Object var5_7 = null;
                return var5_7;
            }
            ArrayList<ListenerInfo> newset = new ArrayList<ListenerInfo>(s);
            newset.remove(li);
            this.busy[indx] = !newset.isEmpty();
            this.collectionArray[indx] = newset;
            EventListener l = li.getListener();
            li.clear();
            --this.cnt;
            EventListener eventListener = l;
            return eventListener;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(EventType type, Reason r, Object target, Object oldval, Object newval) {
        this.shareLock.lock();
        try {
            List<ListenerInfo> listenerList = this.collectionArray[type.getEvent()];
            if (listenerList == null || listenerList.isEmpty()) {
                return;
            }
            int offset = 0;
            int size = listenerList.size();
            if (size > 1) {
                Object object = this.orderMaintainedLock;
                synchronized (object) {
                    if (!this.orderMaintained.booleanValue() && this.start != null) {
                        offset = this.start[type.getEvent()];
                        this.start[type.getEvent()] = offset >= size - 1 ? 0 : offset + 1;
                    }
                }
            }
            for (int count = 0; count < size; ++count) {
                int index;
                ListenerInfo info = null;
                int n = index = offset == 0 ? count : (count + offset) % size;
                if (index >= listenerList.size() || (info = listenerList.get(index)) == null) continue;
                EventListener ll = info.getListener();
                Reason lr = info.getReason();
                Object ud = info.getUserData();
                if (ll == null || lr != null && lr != r) continue;
                ll.eventOccured(type, r, target, oldval, newval, ud);
            }
        }
        finally {
            this.shareLock.unlock();
        }
    }

    public boolean hasListeners(EventType type) {
        this.shareLock.lock();
        try {
            boolean bl = this.busy[type.getEvent()];
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    public boolean hasListeners() {
        this.shareLock.lock();
        try {
            boolean bl = this.cnt > 0;
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    static class ListenerInfo {
        boolean valid = true;
        EventListener l;
        EventType type;
        Object userData;
        Reason reason;

        ListenerInfo(EventListener l, EventType t, Reason r, Object ud) {
            this.l = l;
            this.type = t;
            this.userData = ud;
            this.reason = r;
        }

        Reason getReason() {
            return this.reason;
        }

        boolean isValid() {
            return this.valid;
        }

        Object getUserData() {
            return this.userData;
        }

        EventType getType() {
            return this.type;
        }

        EventListener getListener() {
            return this.l;
        }

        void clear() {
            this.valid = false;
            this.l = null;
            this.userData = null;
            this.reason = null;
            this.type = null;
        }

        public String toString() {
            return String.valueOf(this.l) + "[" + String.valueOf((Object)this.type) + ", reason=" + String.valueOf(this.reason) + ", userData=" + String.valueOf(this.userData) + ", valid=" + this.valid + "]";
        }
    }
}

