/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices.server;

import com.sun.enterprise.security.ee.jmac.callback.ServerContainerCallbackHandler;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.security.webservices.SoapAuthenticationService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.wss.provider.wsit.PacketMapMessageInfo;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.xml.ws.WebServiceException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class ServerSecurityPipe
extends AbstractFilterPipeImpl {
    protected static final Logger _logger = LogUtils.getLogger();
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerSecurityPipe.class);
    private static final String WSIT_SERVER_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITServerAuthContext";
    private final boolean isHttpBinding;
    private final SoapAuthenticationService authenticationService;

    public ServerSecurityPipe(Map<String, Object> props, Pipe next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", (Object)this);
        this.authenticationService = new SoapAuthenticationService("SOAP", props, (CallbackHandler)new ServerContainerCallbackHandler());
        this.isHttpBinding = isHttpBinding;
    }

    protected ServerSecurityPipe(ServerSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.authenticationService = that.authenticationService;
        this.isHttpBinding = that.isHttpBinding;
    }

    public void preDestroy() {
        this.authenticationService.disable();
        try {
            Packet request = new Packet();
            PacketMapMessageInfo messageInfo = new PacketMapMessageInfo(request, new Packet());
            Subject subject = new Subject();
            ServerAuthContext serverAuthContext = this.authenticationService.getServerAuthContext((MessageInfo)messageInfo, subject);
            if (serverAuthContext != null && WSIT_SERVER_AUTH_CONTEXT.equals(serverAuthContext.getClass().getName())) {
                serverAuthContext.cleanSubject((MessageInfo)messageInfo, subject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.next.preDestroy();
    }

    public Pipe copy(PipeCloner cloner) {
        return new ServerSecurityPipe(this, cloner);
    }

    public Packet process(Packet request) {
        Packet response;
        if (this.isHttpBinding) {
            return this.next.process(request);
        }
        try {
            response = this.processRequest(request);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Failure in security pipe process", e);
            response = this.authenticationService.makeFaultResponse(null, e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet processRequest(Packet request) throws Exception {
        AuthStatus status = AuthStatus.SUCCESS;
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        Subject serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
        ServerAuthContext serverAuthContext = this.authenticationService.getServerAuthContext((MessageInfo)info, serverSubject);
        Subject clientSubject = ServerSecurityPipe.getClientSubject(request);
        try {
            if (serverAuthContext != null) {
                status = serverAuthContext.validateRequest((MessageInfo)info, clientSubject, serverSubject);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00002", e);
            WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateRequest", "Cannot validate request for {0}", new Object[]{this.authenticationService.getModelName()}), (Throwable)e);
            status = AuthStatus.SEND_FAILURE;
            Packet packet = this.authenticationService.getFaultResponse(info.getRequestPacket(), info.getResponsePacket(), (Throwable)wse);
            return packet;
        }
        finally {
            Packet validatedRequest = info.getRequestPacket();
            this.authenticationService.auditInvocation(validatedRequest, status);
        }
        _logger.log(Level.FINE, "Validation status: {0}", status);
        Packet response = null;
        if (status == AuthStatus.SUCCESS) {
            Packet validatedRequest;
            boolean authorized = false;
            try {
                this.authenticationService.authorize(validatedRequest);
                authorized = true;
            }
            catch (Exception e) {
                response = this.authenticationService.getFaultResponse(validatedRequest, info.getResponsePacket(), e);
            }
            if (authorized) {
                if (System.getSecurityManager() == null) {
                    try {
                        response = this.next.process(validatedRequest);
                    }
                    catch (Exception e) {
                        _logger.log(Level.SEVERE, "AS-WSSECURITY-00001", e);
                        response = this.authenticationService.getFaultResponse(validatedRequest, info.getResponsePacket(), e);
                    }
                } else {
                    try {
                        response = Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction<Packet>(){

                            @Override
                            public Packet run() throws Exception {
                                return ServerSecurityPipe.this.next.process(validatedRequest);
                            }
                        }, null);
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        _logger.log(Level.SEVERE, "AS-WSSECURITY-00001", cause);
                        response = this.authenticationService.getFaultResponse(validatedRequest, info.getResponsePacket(), cause);
                    }
                }
            }
            if (response == null) {
                WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.nullResponsePacket", "Invocation of Service {0} returned null response packet", new Object[]{this.authenticationService.getModelName()}));
                response = this.authenticationService.getFaultResponse(validatedRequest, info.getResponsePacket(), (Throwable)wse);
                _logger.log(Level.SEVERE, "AS-WSSECURITY-00011", (Throwable)wse);
            }
            if (serverAuthContext != null && response.getMessage() != null) {
                info.setResponsePacket(response);
                response = this.processResponse((PacketMessageInfo)info, serverAuthContext, serverSubject);
            }
        } else {
            response = info.getResponsePacket();
        }
        return response;
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext serverAuthContext, Subject serverSubject) throws Exception {
        AuthStatus status;
        try {
            status = serverAuthContext.secureResponse((MessageInfo)info, serverSubject);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                _logger.log(Level.INFO, "AS-WSSECURITY-00003", e);
            } else {
                _logger.log(Level.SEVERE, "AS-WSSECURITY-00003", e);
            }
            return this.authenticationService.makeFaultResponse(info.getResponsePacket(), e);
        }
        _logger.log(Level.FINE, "ws.status_secure_response", status);
        return info.getResponsePacket();
    }

    private static Subject getClientSubject(Packet packet) {
        Subject clientSubject = null;
        if (packet != null) {
            clientSubject = (Subject)packet.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (clientSubject == null) {
            clientSubject = SoapAuthenticationService.getClientSubject();
            if (packet != null) {
                packet.invocationProperties.put("CLIENT_SUBJECT", clientSubject);
            }
        }
        return clientSubject;
    }
}

