/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.EjbFutureTask;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimerService;
import jakarta.transaction.UserTransaction;
import java.rmi.Remote;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public abstract class AbstractSessionContextImpl
extends EJBContextImpl
implements SessionContext {
    protected Object instanceKey;
    protected String ejbName;

    protected AbstractSessionContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.ejbName = sessionDesc.getName();
    }

    public Object getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(Object instanceKey) {
        this.instanceKey = instanceKey;
    }

    public String toString() {
        return this.ejbName + "; id: " + String.valueOf(this.instanceKey);
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EJBTimerService.getValidEJBTimerService();
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED && this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        return ((BaseContainer)this.getContainer()).getUserTransaction();
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EjbDescriptor ejbDesc = this.container.getEjbDescriptor();
        Object businessObject = this.getBusinessObject(businessInterface, (com.sun.enterprise.deployment.EjbDescriptor)ejbDesc);
        if (businessObject == null) {
            throw new IllegalStateException("Invalid business interface : " + String.valueOf(businessInterface) + " for ejb " + ejbDesc.getName());
        }
        return (T)businessObject;
    }

    @Override
    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        Class businessInterface;
        try {
            ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
            if (inv instanceof EjbInvocation) {
                EjbInvocation invocation = (EjbInvocation)inv;
                businessInterface = invocation.isBusinessInterface ? (this.container.isLocalBeanClass(invocation.clientInterface.getName()) ? this.container.getEJBClass() : invocation.clientInterface) : null;
            } else {
                businessInterface = null;
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        if (businessInterface == null) {
            throw new IllegalStateException("Attempt to call getInvokedBusinessInterface outside the scope of a business method");
        }
        return businessInterface;
    }

    @Override
    public boolean wasCancelCalled() {
        try {
            ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
            if (inv != null && inv instanceof EjbInvocation) {
                EjbInvocation invocation = (EjbInvocation)inv;
                EjbFutureTask task = invocation.getEjbFutureTask();
                if (task == null) {
                    throw new IllegalStateException("Must be invoked from an async method");
                }
                if (invocation.method.getReturnType() == Void.TYPE) {
                    throw new IllegalStateException("Must be invoked from a method with a Future<V> return type");
                }
                return invocation.getWasCancelCalled();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        throw new IllegalStateException("Attempt to invoke wasCancelCalled from outside an ejb invocation");
    }

    @Override
    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    protected ComponentInvocation getCurrentComponentInvocation() {
        return this.container.invocationManager.getCurrentInvocation();
    }

    private boolean isWebServiceInvocation(ComponentInvocation inv) {
        return inv instanceof EjbInvocation && ((EjbInvocation)inv).isWebService;
    }

    private Object getBusinessObject(Class<?> businessInterface, com.sun.enterprise.deployment.EjbDescriptor ejbDesc) {
        if (businessInterface == null) {
            return null;
        }
        String intfName = businessInterface.getName();
        if (this.ejbLocalBusinessObjectImpl != null && ejbDesc.getLocalBusinessClassNames().contains(intfName)) {
            return this.ejbLocalBusinessObjectImpl.getClientObject(intfName);
        }
        if (this.ejbRemoteBusinessObjectImpl != null && ejbDesc.getRemoteBusinessClassNames().contains(intfName)) {
            String generatedIntf = RemoteGenerator.getGeneratedRemoteIntfName(intfName);
            Remote stub = this.ejbRemoteBusinessObjectImpl.getStub(generatedIntf);
            try {
                return EJBUtils.createRemoteBusinessObject(this.container.getClassLoader(), intfName, stub);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating remote business object for " + intfName, e);
            }
        }
        if (ejbDesc.isLocalBean() && intfName.equals(ejbDesc.getEjbClassName())) {
            return this.optionalEjbLocalBusinessObjectImpl.getClientObject(ejbDesc.getEjbClassName());
        }
        return null;
    }
}

