/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import java.util.Collection;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.internal.ui.model.TreeContentProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;

public class ProvidersContentProvider
extends TreeContentProvider<ECPProviderRegistry>
implements ECPProvidersChangedObserver {
    private final boolean excludesProvidersThatCannotAddRepositories;

    public ProvidersContentProvider() {
        this(false);
    }

    public ProvidersContentProvider(boolean excludesProvidersThatCannotAddRepositories) {
        this.excludesProvidersThatCannotAddRepositories = excludesProvidersThatCannotAddRepositories;
    }

    public final boolean excludesProvidersThatCannotAddRepositories() {
        return this.excludesProvidersThatCannotAddRepositories;
    }

    @Override
    protected void fillChildren(Object parent, InternalChildrenList childrenList) {
        if (parent == ECPUtil.getECPProviderRegistry()) {
            Collection providers = ECPUtil.getECPProviderRegistry().getProviders();
            if (!this.excludesProvidersThatCannotAddRepositories) {
                childrenList.addChildren(providers);
            } else {
                for (ECPProvider provider : providers) {
                    if (!provider.hasCreateRepositorySupport()) continue;
                    childrenList.addChild((Object)provider);
                }
            }
        }
    }

    public void providersChanged(Collection<ECPProvider> oldProviders, Collection<ECPProvider> newProviders) {
        this.refreshViewer();
    }

    @Override
    protected void connectInput(ECPProviderRegistry input) {
        super.connectInput(input);
        ECPUtil.getECPObserverBus().register((ECPObserver)this);
    }

    @Override
    protected void disconnectInput(ECPProviderRegistry input) {
        ECPUtil.getECPObserverBus().unregister((ECPObserver)this);
        super.disconnectInput(input);
    }
}

