/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.rulerepository.tooling;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emfforms.internal.editor.toolbaractions.LoadEcoreAction;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;

public class RuleRepositoryEditor
extends GenericEditor {
    protected List<Action> getToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add((Action)new LoadEcoreAction((Object)this.getResourceSet(), "Load ViewModel"));
        return result;
    }

    private void registerEcore(ResourceSet resourceSet) throws IOException {
        for (Resource resource : resourceSet.getResources()) {
            if (resource.getContents().isEmpty() || !VView.class.isInstance(resource.getContents().get(0))) continue;
            String ecorePath = this.getEcorePath(resource);
            if (ecorePath == null) {
                return;
            }
            EcoreHelper.registerEcore((String)ecorePath);
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
    }

    private String getEcorePath(Resource resource) {
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (VView.class.isInstance(eObject)) {
            return ((VView)VView.class.cast(eObject)).getEcorePath();
        }
        if (AnyType.class.isInstance(eObject)) {
            FeatureMap anyAttribute = ((AnyType)AnyType.class.cast(eObject)).getAnyAttribute();
            int i = 0;
            while (i < anyAttribute.size()) {
                EStructuralFeature feature = anyAttribute.getEStructuralFeature(i);
                if ("ecorePath".equals(feature.getName())) {
                    return (String)anyAttribute.getValue(i);
                }
                ++i;
            }
        }
        return null;
    }

    protected ResourceSet loadResource(IEditorInput editorInput) {
        ResourceSet result = super.loadResource(editorInput);
        try {
            this.registerEcore(result);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return super.loadResource(editorInput);
    }

    public void dispose() {
        for (Resource resource : this.getResourceSet().getResources()) {
            if (resource.getContents().isEmpty() || !VView.class.isInstance(resource.getContents().get(0))) continue;
            String ecorePath = this.getEcorePath(resource);
            if (ecorePath == null) {
                return;
            }
            EcoreHelper.unregisterEcore((String)ecorePath);
        }
        super.dispose();
    }
}

