/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.launch;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Command;

class RLSRunCommand {
    public final String binary;
    public final Map<String, String> env;
    public final String[] args;

    private RLSRunCommand(String binary, Map<String, String> env, String[] args) {
        this.binary = binary;
        this.env = env;
        this.args = args;
    }

    public static Optional<RLSRunCommand> fromLSPCommand(Command command) {
        List arguments = command.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return Optional.empty();
        }
        Object argumentsObj = arguments.get(0);
        Map argMap = RLSRunCommand.castOrNull(argumentsObj, Map.class);
        if (argMap == null) {
            return Optional.empty();
        }
        Object binaryObj = argMap.get("binary");
        if (binaryObj == null) {
            return Optional.empty();
        }
        String binary = Objects.toString(binaryObj);
        List argsObj = RLSRunCommand.castOrNull(argMap.get("args"), List.class);
        if (argsObj == null) {
            return Optional.empty();
        }
        String[] args = (String[])argsObj.stream().filter(String.class::isInstance).map(String.class::cast).toArray(String[]::new);
        Map envObjsMap = RLSRunCommand.castOrNull(argMap.get("env"), Map.class);
        if (envObjsMap == null) {
            return Optional.empty();
        }
        Map<String, String> envMap = envObjsMap.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(e -> Objects.toString(e.getKey()), e -> Objects.toString(e.getValue())));
        return Optional.of(new RLSRunCommand(binary, envMap, args));
    }

    private static <T> T castOrNull(Object o, Class<T> clazz) {
        if (!clazz.isInstance(o)) {
            return null;
        }
        return clazz.cast(o);
    }
}

