/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.dialogs.TextURLDropAdapter;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RepositoryDialog
extends StatusDialog {
    private Text fLocation;
    private String fRepoURL;
    private String fLocationStr;

    public RepositoryDialog(Shell shell, String repoURL) {
        super(shell);
        this.fRepoURL = repoURL;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).numColumns = 2;
        WidgetFactory.label((int)0).text(PDEUIMessages.UpdatesSection_Location).create((Widget)comp);
        this.fLocation = (Text)WidgetFactory.text((int)2048).create((Widget)comp);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.fLocation.setLayoutData((Object)data);
        DropTarget target = new DropTarget((Control)this.fLocation, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new TextURLDropAdapter(this.fLocation, true));
        this.fLocation.addModifyListener(e -> this.validate());
        if (this.fRepoURL != null) {
            this.fLocation.setText(this.fRepoURL);
        }
        this.validate();
        return comp;
    }

    protected void validate() {
        this.fLocationStr = this.fLocation.getText().trim();
        this.updateStatus((IStatus)this.isValidURL(this.fLocationStr));
    }

    private Status isValidURL(String location) {
        if (location.length() == 0) {
            return new Status(4, "org.eclipse.pde.ui", PDEUIMessages.UpdatesSection_ErrorInvalidURL);
        }
        if (!(location.startsWith("http://") || location.startsWith("https://") || location.startsWith("file:/"))) {
            return new Status(4, "org.eclipse.pde.ui", PDEUIMessages.UpdatesSection_ErrorInvalidURL);
        }
        try {
            URL url = new URL(location);
            if (url.getHost().trim().isBlank() && url.getPath().isBlank()) {
                return new Status(4, "org.eclipse.pde.ui", PDEUIMessages.UpdatesSection_ErrorInvalidURL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return new Status(4, "org.eclipse.pde.ui", PDEUIMessages.UpdatesSection_ErrorInvalidURL);
        }
        return new Status(0, "org.eclipse.pde.ui", "");
    }

    protected Control createHelpControl(Composite parent) {
        return parent;
    }

    public String getResult() {
        return this.fLocationStr;
    }
}

