/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.contentassist;

import com.google.inject.Inject;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.ui.contentassist.AbstractProjectProposalProvider;
import org.eclipse.comma.project.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TaskProposalProvider
extends AbstractProjectProposalProvider {
    @Inject
    private IScopeProvider scopeProvider;
    private final Image templateIcon;
    public static String INAME = "IName";
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;
    protected static String GENERATE_MONITORING_INFO = "Task for monitoring";
    protected static String GENERATE_MAPPINGS_INFO = "Type Mappings for generation.";
    protected static String GENERATE_MAPPINGS_SIMPLE_INFO = "Type Mappings for generation with Simple Type suggestions";
    protected static String GENERATE_DOCUMENTATION_INFO = "Task for how to generate the documentation";
    protected static String GENERATE_STUB_INFO = "Task for generating Stub and UI CPP code.";
    protected static String GENERATE_UML_INFO = "Task for generating Plant UML images.";
    protected final String TASK_SIMULATION = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("simulation for interface %s");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_UML = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("umlTask for interface %s");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_STUB_INTERFACE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("stubTask for interface %s {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude command: <Provide command Names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude signal: <Provide signal Names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude notification: <Provide notification names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("latency: 10 seconds // Polling delay of the simulation | stub behavior");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("parameters file: \"file.params\" // Provide the correct name of the input parameters file");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("auto-launch-console: NO // Build and launch of the console simulation on Execute CommaSuite Workflow?");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("auto-launch-gui: NO // Build and launch of the GUI simulation on Execute CommaSuite Workflow?");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// The following attribute is OPTIONAL. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// It is used to specify a different location for the BAT File: vcvarsall.bat [located in your Visual Studio Installation]");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// If not specified then the default path is assumed, i.e. \"C:\\\\Program Files (x86)\\\\Microsoft Visual Studio\\\\2017\\\\Community\\\\VC\\\\Auxiliary\\\\Build\\\\\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// msvc-install-path: \"C:\\\\Program Files (x86)\\\\Microsoft Visual Studio\\\\2017\\\\Community\\\\VC\\\\Auxiliary\\\\Build\\\\\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("overwrite-server-stub-helper: YES // Overwrite the helper file generated by the server stub?");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("overwrite-client-stub-adapter: YES // Overwrite the generated client stub adapter implementation?");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_MONITOR = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("monitoring for interface %s {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("trace files");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"file.events\"");
            _builder.newLine();
            _builder.append("}");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TYPE_MAPPINGS = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("typeMappings {");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("}");
            return _builder.toString();
        }
    }.apply();
    protected final String COMPOUND_INTERFACE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ICompound {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("version");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"0.1\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("description");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"Description\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("interfaces");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("%s");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_INPUT_TEMPLATE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("inputTemplateTask for interface %s");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TEST_APPLICATION_GEN_INFO = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Task for generating a test application");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TEST_APPLICATION_GEN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("TestApplication_%s for %s %s");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("params: %s");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_SIM_GEN_INFO = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Task for generating a Simulator");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_SIM_GEN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Simulator_%s for %s %s");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("params: %s");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TEST_CASES_GEN_INFO = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Task for generating test cases");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TEST_CASES_GEN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("TestCases_%s for interface %s {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("template: java");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("output-file: 'Test.java'");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("max-depth: 1000");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("params: '%s'");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_MODEL_QUALITY_CHECKS_GEN_INFO = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Task for generating model quality checks");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_MODEL_QUALITY_CHECKS_GEN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ModelQualityChecks_%s for interface %s {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("params: '%s.params'");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("max-depth: 1000");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("home-states: { %s }");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();

    @Override
    public void complete_MonitoringTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        super.complete_MonitoringTask(model, ruleCall, context, acceptor);
        this.acceptMonitoringTask(INAME, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptMonitoringTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptMonitoringTask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_MONITOR, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("Monitoring Task " + name, proposalSimple, GENERATE_MONITORING_INFO, 2, context));
    }

    @Override
    public void complete_DocumentationGenerationTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.getDocumentationTask(), INAME);
        acceptor.accept((ICompletionProposal)this.createTemplate("Documentation Task Example", proposal, GENERATE_DOCUMENTATION_INFO, 1, context));
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptDocumenationTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptDocumenationTask(String iName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.getDocumentationTask(), iName);
        acceptor.accept((ICompletionProposal)this.createTemplate("Documentation Task for interface " + iName, proposal, "", 1, context));
    }

    @Override
    public void complete_UMLTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        this.acceptUMLTask(INAME, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptUMLTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptUMLTask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_UML, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("UML Task " + name, proposalSimple, GENERATE_UML_INFO, 2, context));
    }

    public void acceptCPPStubAndUITask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_STUB_INTERFACE, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("Stub and UI Task " + name, proposalSimple, GENERATE_STUB_INFO, 2, context));
    }

    @Override
    public void complete_CompoundInterface(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        super.complete_CompoundInterface(model, ruleCall, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptCompoundInterface(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptCompoundInterface(String iName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.COMPOUND_INTERFACE, iName);
        acceptor.accept((ICompletionProposal)this.createTemplate("Compound Interface with interface" + iName, proposal, "", 2, context));
    }

    @Override
    public void complete_ModelQualityChecksGenerationTask(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ModelQualityChecksGenerationTask(model, ruleCall, context, acceptor);
        String text = this.complete_ModelQualityChecksGenerationTaskBody(model);
        acceptor.accept((ICompletionProposal)this.createTemplate("Model Quality Checks generation Task", text, this.TASK_MODEL_QUALITY_CHECKS_GEN_INFO, 2, context));
    }

    public String complete_ModelQualityChecksGenerationTaskBody(EObject model) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        List<Interface> _interfaces = this.getInterfaces(model);
        for (Interface itf : _interfaces) {
            Functions.Function1<StateMachine, String> _function = new Functions.Function1<StateMachine, String>(){

                public String apply(StateMachine m) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State s) {
                            return s.isInitial();
                        }
                    };
                    return ((State)IterableExtensions.findFirst((Iterable)m.getStates(), (Functions.Function1)_function)).getName();
                }
            };
            String _format = String.format(this.TASK_MODEL_QUALITY_CHECKS_GEN, itf.getName(), itf.getName(), itf.getName(), String.join((CharSequence)" ", ListExtensions.map((List)itf.getMachines(), (Functions.Function1)_function)));
            _builder.append(_format);
            _builder.newLineIfNotEmpty();
        }
        String text = _builder.toString();
        boolean _isBlank = text.isBlank();
        if (_isBlank) {
            text = String.format(this.TASK_MODEL_QUALITY_CHECKS_GEN, INAME, INAME, INAME, "InitialState");
        }
        _xblockexpression = text;
        return _xblockexpression;
    }

    @Override
    public void complete_TestCasesGenerationTask(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TestCasesGenerationTask(model, ruleCall, context, acceptor);
        String text = this.complete_TestCasesGenerationTaskBody(model);
        acceptor.accept((ICompletionProposal)this.createTemplate("Test cases generation Task", text, this.TASK_TEST_CASES_GEN_INFO, 2, context));
    }

    public String complete_TestCasesGenerationTaskBody(EObject model) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        List<Interface> _interfaces = this.getInterfaces(model);
        for (Interface itf : _interfaces) {
            String _name = itf.getName();
            String _name_1 = itf.getName();
            String _name_2 = itf.getName();
            String _plus = String.valueOf(_name_2) + ".params";
            String _format = String.format(this.TASK_TEST_CASES_GEN, _name, _name_1, _plus);
            _builder.append(_format);
            _builder.newLineIfNotEmpty();
        }
        String text = _builder.toString();
        boolean _isBlank = text.isBlank();
        if (_isBlank) {
            text = String.format(this.TASK_TEST_CASES_GEN, INAME, INAME);
        }
        _xblockexpression = text;
        return _xblockexpression;
    }

    @Override
    public void complete_TestApplicationGenerationTask(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TestApplicationGenerationTask(model, ruleCall, context, acceptor);
        String text = this.complete_TestApplicationGenerationTaskBody(model);
        acceptor.accept((ICompletionProposal)this.createTemplate("Test application generation Task", text, this.TASK_TEST_APPLICATION_GEN_INFO, 2, context));
    }

    public String complete_TestApplicationGenerationTaskBody(EObject model) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        List<Interface> _interfaces = this.getInterfaces(model);
        for (Interface itf : _interfaces) {
            String _name = itf.getName();
            String _name_1 = itf.getName();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            String _name_2 = itf.getName();
            _builder_1.append(_name_2);
            _builder_1.append("/");
            String _name_3 = itf.getName();
            _builder_1.append(_name_3);
            _builder_1.append(".params\"");
            String _format = String.format(this.TASK_TEST_APPLICATION_GEN, _name, "interface", _name_1, _builder_1);
            _builder.append(_format);
            _builder.newLineIfNotEmpty();
        }
        List<Component> _components = this.getComponents(model);
        for (Component comp : _components) {
            Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                public Boolean apply(Port p) {
                    return p instanceof ProvidedPort;
                }
            };
            Functions.Function1<Port, String> _function_1 = new Functions.Function1<Port, String>(){

                public String apply(Port p) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("\"");
                    String _name = p.getInterface().getName();
                    _builder.append(_name);
                    _builder.append("/");
                    String _name_1 = p.getInterface().getName();
                    _builder.append(_name_1);
                    _builder.append(".params\"");
                    return _builder.toString().trim();
                }
            };
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)comp.getPorts(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            String _format_1 = String.format(this.TASK_TEST_APPLICATION_GEN, comp.getName(), "component", comp.getName(), IterableExtensions.join(new HashSet(_list), (CharSequence)" "));
            _builder.append(_format_1);
            _builder.newLineIfNotEmpty();
        }
        String text = _builder.toString();
        boolean _isBlank = text.isBlank();
        if (_isBlank) {
            text = String.format(this.TASK_TEST_APPLICATION_GEN, INAME, INAME, INAME, INAME);
        }
        _xblockexpression = text;
        return _xblockexpression;
    }

    @Override
    public void complete_SimulatorGenerationTask(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_SimulatorGenerationTask(model, ruleCall, context, acceptor);
        String text = this.complete_SimulatorGenerationTaskBody(model);
        acceptor.accept((ICompletionProposal)this.createTemplate("Simulator generation Task", text, this.TASK_SIM_GEN_INFO, 2, context));
    }

    public String complete_SimulatorGenerationTaskBody(EObject model) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        List<Interface> _interfaces = this.getInterfaces(model);
        for (Interface itf : _interfaces) {
            String _name = itf.getName();
            String _name_1 = itf.getName();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            String _name_2 = itf.getName();
            _builder_1.append(_name_2);
            _builder_1.append("/");
            String _name_3 = itf.getName();
            _builder_1.append(_name_3);
            _builder_1.append(".params\"");
            String _format = String.format(this.TASK_SIM_GEN, _name, "interface", _name_1, _builder_1);
            _builder.append(_format);
            _builder.newLineIfNotEmpty();
        }
        List<Component> _components = this.getComponents(model);
        for (Component comp : _components) {
            Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                public Boolean apply(Port p) {
                    return p instanceof ProvidedPort;
                }
            };
            Functions.Function1<Port, String> _function_1 = new Functions.Function1<Port, String>(){

                public String apply(Port p) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("\"");
                    String _name = p.getInterface().getName();
                    _builder.append(_name);
                    _builder.append("/");
                    String _name_1 = p.getInterface().getName();
                    _builder.append(_name_1);
                    _builder.append(".params\"");
                    return _builder.toString().trim();
                }
            };
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)comp.getPorts(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            String _format_1 = String.format(this.TASK_SIM_GEN, comp.getName(), "component", comp.getName(), IterableExtensions.join(new HashSet(_list), (CharSequence)" "));
            _builder.append(_format_1);
            _builder.newLineIfNotEmpty();
        }
        String text = _builder.toString();
        boolean _isBlank = text.isBlank();
        if (_isBlank) {
            text = String.format(this.TASK_SIM_GEN, INAME, INAME, INAME, INAME);
        }
        _xblockexpression = text;
        return _xblockexpression;
    }

    public TaskProposalProvider() {
        this.templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    }

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, 600);
    }

    protected String addIndents(String content, Integer nrIndents, boolean newLine) {
        String _xblockexpression = null;
        String indent = "";
        int i = 0;
        while (i < nrIndents) {
            String _indent = indent;
            indent = String.valueOf(_indent) + "\t";
            ++i;
        }
        String _lineSeparator = System.lineSeparator();
        String _lineSeparator_1 = System.lineSeparator();
        String _plus = String.valueOf(_lineSeparator_1) + indent;
        String indentedContent = content.replace(_lineSeparator, _plus);
        if (newLine) {
            String _lineSeparator_2 = System.lineSeparator();
            String _plus_1 = String.valueOf(_lineSeparator_2) + indent;
            return String.valueOf(_plus_1) + indentedContent;
        }
        _xblockexpression = String.valueOf(indent) + indentedContent;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int priority) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String indentedContent = this.addIndents(content, nrIndents, true);
        while (indentedContent.startsWith("\n") || indentedContent.startsWith("\r") || indentedContent.startsWith("\t")) {
            indentedContent = indentedContent.substring(1);
        }
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(indentedContent, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo(finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        boolean _isValidProposal = this.isValidProposal(proposal, context.getPrefix(), context);
        if (_isValidProposal) {
            return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean containsBlock(EObject model, EClass blockClass) {
        if (model instanceof Project) {
            EList _generatorBlocks = ((Project)model).getGeneratorBlocks();
            for (GeneratorBlock block : _generatorBlocks) {
                boolean _tripleEquals;
                EClass _eClass = block.eClass();
                boolean bl = _tripleEquals = _eClass == blockClass;
                if (!_tripleEquals) continue;
                return true;
            }
        }
        return false;
    }

    public String getDocumentationTask() {
        return "";
    }

    public List<Interface> getInterfaces(EObject model) {
        return ComponentUtilities.getAllInterfaces((EObject)model, (IScopeProvider)this.scopeProvider);
    }

    public List<Component> getComponents(EObject model) {
        return ComponentUtilities.getAllComponents((EObject)model, (IScopeProvider)this.scopeProvider);
    }
}

