/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.util.Arrays;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.factory.primitive.ShortBags;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;

public abstract class AbstractShortIterable
implements ShortIterable {
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return this.toList().sortThis();
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    public MutableShortList toList() {
        return ShortLists.mutable.withAll((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll((ShortIterable)this);
    }
}

