/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag;

import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.procedure.Procedure;

public interface MultiReaderBag<T>
extends MutableBag<T> {
    public void withReadLockAndDelegate(Procedure<? super MutableBag<T>> var1);

    public void withWriteLockAndDelegate(Procedure<? super MutableBag<T>> var1);

    @Override
    public MultiReaderBag<T> newEmpty();

    @Override
    default public MultiReaderBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MultiReaderBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MultiReaderBag<T> withOccurrences(T element, int occurrences) {
        this.addOccurrences(element, occurrences);
        return this;
    }

    @Override
    default public MultiReaderBag<T> withoutOccurrences(T element, int occurrences) {
        this.removeOccurrences(element, occurrences);
        return this;
    }

    @Override
    default public MultiReaderBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MultiReaderBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    default public MultiReaderBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }
}

