/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.validator.constraints.StringParser;

public class EFVRT_03
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        Comment c = (Comment)eObject;
        IStatus success = ctx.createSuccessStatus();
        IStatus failure = ctx.createFailureStatus(new Object[]{c.getAnnotatedElements(), c.getNearestPackage().getName()});
        boolean rightView = false;
        Package ownerP = c.getNearestPackage();
        if (ViewUtils.isExtraFunctionalView((Package)ownerP)) {
            rightView = true;
        } else {
            EList pkg = c.getNearestPackage().allOwningPackages();
            for (Package it : pkg) {
                if (!ViewUtils.isExtraFunctionalView((Package)it)) continue;
                rightView = true;
            }
        }
        if (rightView) {
            StringParser parser = new StringParser();
            Stereotype s = c.getAppliedStereotype("CHESS-ML::Predictability::RTComponentModel::CH_RtSpecification");
            if (s == null) {
                return success;
            }
            if (c.getValue(s, "partWithPort") == null) {
                return success;
            }
            String occValue = (String)c.getValue(s, "occKind");
            String wcet = (String)c.getValue(s, "WCET");
            String relDl = (String)c.getValue(s, "relDl");
            if (occValue == null || !occValue.contains("PeriodicPattern")) {
                return success;
            }
            if (wcet == null || relDl == null) {
                return failure;
            }
            double period = parser.getValuePattern(occValue, "period");
            if (!(period >= 0.0)) {
                return failure;
            }
            double wcetValue = parser.getValueNFP(wcet);
            if (!(wcetValue >= 0.0)) {
                return failure;
            }
            double relDlValue = parser.getValueNFP(relDl);
            if (!(relDlValue >= 0.0)) {
                return failure;
            }
            return success;
        }
        return success;
    }
}

