/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaWorkloadBehavior;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaEndtoEndFlow;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.IdentifInstance;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.m2m.transformations.PIMPSMTransformationEnd2End;
import org.polarsys.chess.m2m.transformations.TransUtil;
import org.polarsys.chess.m2m.transformations.TransformationResultsData;
import org.polarsys.chess.m2m.ui.AnalysisContextSelectionDialog;
import org.polarsys.chess.m2m.ui.End2EndResultDialog;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class QVToUIHandlerEnd2End
extends AbstractHandler {
    private static final String SAANALYSISCONTEXT = "MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext";
    private static final String SAENDTOENDFLOW = "MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow";
    private Shell activeShell = null;
    private Resource inResource = null;
    private Class contextClass;
    private String deadline;
    private String scenario;
    private String saAnalysisName;
    private String saE2EFlowName;
    private SaEndtoEndFlow saE2EFlow;
    private SaAnalysisContext saAnalysisCtx;
    private String psmPackageName;

    private IProject getActiveProject(IEditorPart editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        return file.getProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!CHESSEditorUtils.isCHESSProject((IEditorPart)editor)) {
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.activeShell = window.getShell();
        try {
            this.inResource = ResourceUtils.getUMLResource((ServicesRegistry)((PapyrusMultiDiagramEditor)editor).getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        ArrayList<Class> selection = new ArrayList<Class>();
        Model model = (Model)this.inResource.getContents().get(0);
        EList elemList = model.allOwnedElements();
        for (Element elem : elemList) {
            SaAnalysisContext saAnalysisCtx;
            if (!(elem instanceof Class) || elem.getAppliedStereotype(SAANALYSISCONTEXT) == null || ViewUtils.isPSMView((Package)ViewUtils.getView((EObject)elem)) || (saAnalysisCtx = (SaAnalysisContext)elem.getStereotypeApplication(elem.getAppliedStereotype(SAANALYSISCONTEXT))).getWorkload().size() <= 0) continue;
            selection.add((Class)elem);
        }
        if (selection.size() == 0) {
            MessageDialog.openWarning((Shell)this.activeShell, (String)"CHESS", (String)"no suitable analysis contexts in the model");
            return null;
        }
        String contextQN = null;
        AnalysisContextSelectionDialog dialog = new AnalysisContextSelectionDialog(this.activeShell, selection, "Select End-To-End Context to analyze");
        if (dialog.open() == 0) {
            contextQN = dialog.getContext();
            if (contextQN == null || contextQN.isEmpty()) {
                return null;
            }
            for (Element elem : model.allOwnedElements()) {
                if (elem.getAppliedStereotype(SAANALYSISCONTEXT) == null || !((NamedElement)elem).getQualifiedName().equals(contextQN)) continue;
                this.contextClass = (Class)elem;
            }
        } else {
            return null;
        }
        this.saAnalysisName = this.contextClass.getQualifiedName();
        this.psmPackageName = String.valueOf(this.contextClass.getName()) + "_PSM";
        Stereotype stereo = this.contextClass.getAppliedStereotype(SAANALYSISCONTEXT);
        this.saAnalysisCtx = (SaAnalysisContext)this.contextClass.getStereotypeApplication(stereo);
        EList workloadList = this.saAnalysisCtx.getWorkload();
        if (workloadList.size() != 1) {
            return null;
        }
        GaWorkloadBehavior workload = (GaWorkloadBehavior)workloadList.get(0);
        NamedElement nelem = workload.getBase_NamedElement();
        if (!(nelem instanceof Activity)) {
            return null;
        }
        Activity workloadActivity = (Activity)nelem;
        this.saE2EFlowName = workloadActivity.getQualifiedName();
        stereo = workloadActivity.getApplicableStereotype(SAENDTOENDFLOW);
        this.saE2EFlow = (SaEndtoEndFlow)workloadActivity.getStereotypeApplication(stereo);
        this.deadline = (String)this.saE2EFlow.getEnd2EndD().get(0);
        CallBehaviorAction callbehaviour = null;
        EList nodes = workloadActivity.getNodes();
        for (ActivityNode activityNode : nodes) {
            if (!(activityNode instanceof CallBehaviorAction)) continue;
            callbehaviour = (CallBehaviorAction)activityNode;
        }
        if (!(callbehaviour.getBehavior() instanceof Interaction)) {
            return null;
        }
        final Interaction interaction = (Interaction)callbehaviour.getBehavior();
        this.scenario = interaction.getQualifiedName();
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TransformationResultsData result = null;
                    try {
                        result = QVToUIHandlerEnd2End.this.executeTimingAnalysis(editor, monitor);
                        CHESSEditorUtils.reopenEditor((IEditorPart)editor, (Boolean)false);
                    }
                    finally {
                        QVToUIHandlerEnd2End.this.getActiveProject(editor).refreshLocal(2, monitor);
                    }
                    try {
                        ModelContent inModel = TransUtil.loadModel(result.umlFile);
                        Model model = (Model)inModel.getContent().get(0);
                        QVToUIHandlerEnd2End.this.openE2EAnalysisReport(model, QVToUIHandlerEnd2End.this.saAnalysisName, interaction);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Unable to load the model and so open the schedAnalysisReport");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new Status(4, "org.polarsys.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    public TransformationResultsData executeTimingAnalysis(IEditorPart editor, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Transforming", 4);
        if (!CHESSEditorUtils.isCHESSProject((IEditorPart)editor)) {
            return null;
        }
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)this.inResource);
        PIMPSMTransformationEnd2End t = new PIMPSMTransformationEnd2End();
        t.setFolder("End-To-End_schedulability_analysis");
        HashMap<String, String> configProps = new HashMap<String, String>();
        configProps.put("deadline", this.deadline);
        configProps.put("scenario", this.scenario);
        configProps.put("saAnalysis", this.saAnalysisName);
        configProps.put("saE2EFlow", this.saE2EFlowName);
        configProps.put("analysisType", "EndToEnd");
        t.setConfigProperty(configProps);
        t.setPsmPackageName(this.psmPackageName);
        TransformationResultsData result = t.performTimingAnalysisWithMAST((PapyrusMultiDiagramEditor)editor, inputFile, monitor);
        return result;
    }

    public void openE2EAnalysisReport(Model model, String saAnalysisName, Interaction interaction) {
        SaAnalysisContext saAnCtx = null;
        SaEndtoEndFlow saflow = null;
        Package anView = ViewUtils.getCHESSRtAnalysisPackage((Model)model);
        for (Element elem : anView.allOwnedElements()) {
            if (!(elem instanceof Class) || !((Class)elem).getQualifiedName().equals(saAnalysisName) || (saAnCtx = (SaAnalysisContext)UMLUtils.getStereotypeApplication((Element)elem, SaAnalysisContext.class)).getWorkload().size() <= 0) continue;
            saflow = (SaEndtoEndFlow)UMLUtils.getStereotypeApplication((Element)((GaWorkloadBehavior)saAnCtx.getWorkload().get(0)).getBase_NamedElement(), SaEndtoEndFlow.class);
        }
        EList messages = interaction.getMessages();
        ArrayList<Operation> e2eOperations = new ArrayList<Operation>();
        for (Message msg : messages) {
            Operation op = (Operation)msg.getSignature();
            if (op.eIsProxy()) {
                op = (Operation)EcoreUtil.resolve((EObject)op, (ResourceSet)model.eResource().getResourceSet());
            }
            e2eOperations.add(op);
        }
        ArrayList<CH_HwProcessor> cpus = new ArrayList<CH_HwProcessor>();
        ArrayList<CHRtPortSlot> specifications = new ArrayList<CHRtPortSlot>();
        ArrayList<Assign> assigns = new ArrayList<Assign>();
        for (Element elem : model.allOwnedElements()) {
            Assign assign;
            CH_HwProcessor chHwProc;
            CHRtPortSlot chrtSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)elem, CHRtPortSlot.class);
            if (chrtSlot != null && UMLUtils.getStereotypeApplication((Element)chrtSlot.getBase_Slot().getOwner(), IdentifInstance.class) != null) {
                specifications.add(chrtSlot);
            }
            if (elem instanceof InstanceSpecification && (chHwProc = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)elem, CH_HwProcessor.class)) != null) {
                cpus.add(chHwProc);
            }
            if ((assign = (Assign)UMLUtils.getStereotypeApplication((Element)elem, Assign.class)) == null) continue;
            assigns.add(assign);
        }
        QVToUIHandlerEnd2End.launchDialog(model, cpus, saAnCtx, saflow, e2eOperations, assigns, specifications);
    }

    private static void launchDialog(final Model model, final List<CH_HwProcessor> cpus, final SaAnalysisContext saAnCtx, final SaEndtoEndFlow saflow, final List<Operation> e2eOperations, final List<Assign> assigns, final List<CHRtPortSlot> specifications) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                End2EndResultDialog e2eDialog = new End2EndResultDialog(shell, model);
                e2eDialog.setCpus(cpus);
                e2eDialog.setSpecifications(specifications);
                e2eDialog.setSaAnalysisCtx(saAnCtx);
                e2eDialog.setSaE2EFlow(saflow);
                e2eDialog.setMessages(e2eOperations);
                e2eDialog.setAssigns(assigns);
                if (e2eDialog.open() == 0) {
                    System.out.println("OK");
                }
            }
        });
    }
}

