/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.Binding;
import org.eclipse.ui.internal.navigator.extensions.CommonDragAssistantDescriptor;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.MenuInsertionPoint;

public final class NavigatorViewerDescriptor
implements INavigatorViewerDescriptor {
    public static final String PROP_ENFORCE_HAS_CHILDREN = "org.eclipse.ui.navigator.enforceHasChildren";
    static final String TAG_INCLUDES = "includes";
    static final String TAG_EXCLUDES = "excludes";
    static final String ATT_IS_ROOT = "isRoot";
    static final String ATT_PATTERN = "pattern";
    private static final String TAG_CONTENT_EXTENSION = "contentExtension";
    private static final String TAG_ACTION_EXTENSION = "actionExtension";
    private final String viewerId;
    private String popupMenuId = null;
    private Binding actionBinding = new Binding("actionExtension");
    private Binding contentBinding = new Binding("contentExtension");
    private MenuInsertionPoint[] customInsertionPoints = null;
    private boolean allowsPlatformContributions = true;
    private String inheritBindingsFromViewer;
    private String helpContext;
    private final Properties properties = new Properties();
    private Set dragAssistants;

    NavigatorViewerDescriptor(String aViewerId) {
        this.viewerId = aViewerId;
    }

    @Override
    public String getViewerId() {
        return this.viewerId;
    }

    @Override
    public String getPopupMenuId() {
        return this.popupMenuId != null ? this.popupMenuId : this.viewerId;
    }

    public void consumeActionBinding(IConfigurationElement element) {
        this.consumeBinding(element, false);
    }

    public void consumeContentBinding(IConfigurationElement element) {
        this.consumeBinding(element, true);
    }

    @Override
    public boolean isRootExtension(String aContentExtensionId) {
        return this.contentBinding.isRootExtension(aContentExtensionId);
    }

    @Override
    public boolean allowsPlatformContributionsToContextMenu() {
        return this.allowsPlatformContributions;
    }

    @Override
    public boolean isVisibleContentExtension(String aContentExtensionId) {
        return this.contentBinding.isVisibleExtension(aContentExtensionId);
    }

    @Override
    public boolean isVisibleActionExtension(String anActionExtensionId) {
        return this.actionBinding.isVisibleExtension(anActionExtensionId);
    }

    @Override
    public boolean hasOverriddenRootExtensions() {
        return this.contentBinding.hasOverriddenRootExtensions();
    }

    @Override
    public MenuInsertionPoint[] getCustomInsertionPoints() {
        return this.customInsertionPoints;
    }

    public void setCustomInsertionPoints(MenuInsertionPoint[] newCustomInsertionPoints) {
        if (this.customInsertionPoints != null) {
            NavigatorPlugin.logError(0, "Attempt to override custom insertion points denied. Verify there are no colliding org.eclipse.ui.navigator.viewer extension points.", null);
            return;
        }
        this.customInsertionPoints = newCustomInsertionPoints;
    }

    public void setAllowsPlatformContributions(boolean toAllowPlatformContributions) {
        this.allowsPlatformContributions = toAllowPlatformContributions;
    }

    public String getInheritBindingsFromViewer() {
        return this.inheritBindingsFromViewer;
    }

    public void setInheritBindingsFromViewer(String inherit) {
        this.inheritBindingsFromViewer = inherit;
    }

    @Override
    public String getHelpContext() {
        return this.helpContext;
    }

    public void setHelpContext(String context) {
        this.helpContext = context;
    }

    public void setContentBinding(Binding binding) {
        this.contentBinding = binding;
    }

    public Binding getContentBinding() {
        return this.contentBinding;
    }

    public void setActionBinding(Binding binding) {
        this.actionBinding = binding;
    }

    public Binding getActionBinding() {
        return this.actionBinding;
    }

    public void setDragAssistants(Set assistants) {
        this.dragAssistants = assistants;
    }

    @Override
    public String getStringConfigProperty(String aPropertyName) {
        return this.properties.getProperty(aPropertyName);
    }

    @Override
    public boolean getBooleanConfigProperty(String aPropertyName) {
        String propValue = this.properties.getProperty(aPropertyName);
        if (propValue == null) {
            return false;
        }
        return Boolean.valueOf(propValue);
    }

    void setProperty(String aPropertyName, String aPropertyValue) {
        this.properties.setProperty(aPropertyName, aPropertyValue);
    }

    public String toString() {
        return "ViewerDescriptor[" + this.viewerId + "]";
    }

    void setPopupMenuId(String newPopupMenuId) {
        if (newPopupMenuId != null) {
            if (this.popupMenuId != null) {
                NavigatorPlugin.log(2, 0, NLS.bind((String)CommonNavigatorMessages.NavigatorViewerDescriptor_Popup_Menu_Overridden, (Object[])new Object[]{this.getViewerId(), this.popupMenuId, newPopupMenuId}), null);
            }
            this.popupMenuId = newPopupMenuId;
        }
    }

    void addDragAssistant(CommonDragAssistantDescriptor descriptor) {
        this.getDragAssistants().add(descriptor);
    }

    public Set getDragAssistants() {
        if (this.dragAssistants == null) {
            this.dragAssistants = new HashSet();
        }
        return this.dragAssistants;
    }

    private void consumeBinding(IConfigurationElement element, boolean isContent) {
        IConfigurationElement[] includesElement = element.getChildren(TAG_INCLUDES);
        if (includesElement.length == 1) {
            if (isContent) {
                this.contentBinding.consumeIncludes(includesElement[0], true);
            } else {
                this.actionBinding.consumeIncludes(includesElement[0], false);
            }
        } else if (includesElement.length >= 1) {
            NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Too_many_elements_Warning, (Object[])new Object[]{TAG_INCLUDES, element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()}), null);
        }
        IConfigurationElement[] excludesElement = element.getChildren(TAG_EXCLUDES);
        if (excludesElement.length == 1) {
            if (isContent) {
                this.contentBinding.consumeExcludes(excludesElement[0]);
            } else {
                this.actionBinding.consumeExcludes(excludesElement[0]);
            }
        } else if (excludesElement.length >= 1) {
            NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Too_many_elements_Warning, (Object[])new Object[]{TAG_EXCLUDES, element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()}), null);
        }
    }

    void updateFromParent(NavigatorViewerDescriptor parent) {
        this.getActionBinding().addBinding(parent.getActionBinding());
        this.getContentBinding().addBinding(parent.getContentBinding());
        this.getDragAssistants().addAll(parent.getDragAssistants());
    }
}

