/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ChromatogramComparisonResult;
import org.eclipse.chemclipse.model.identifier.ChromatogramLibraryInformation;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.IChromatogramMSDZipReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.ChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrometer;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrumType;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader_0701
extends AbstractChromatogramReader
implements IChromatogramMSDZipReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader_0701.class);

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramMSD chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogram = this.readFromZipFile(zipFile, "", file, monitor);
            }
        }
        return chromatogram;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogramOverview = this.readOverviewFromZipFile(zipFile, "", monitor);
            }
        }
        return chromatogramOverview;
    }

    @Override
    public IChromatogramMSD read(ZipInputStream zipInputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipInputStream, directoryPrefix, null, monitor);
    }

    @Override
    public IChromatogramMSD read(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readFromZipFile(zipFile, directoryPrefix, null, monitor);
    }

    private IChromatogramMSD readFromZipFile(ZipFile zipFile, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipFile, directoryPrefix, file, monitor);
    }

    private IChromatogramMSD readZipData(Object object, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        boolean closeStream;
        if (object instanceof ZipFile) {
            closeStream = true;
        } else if (object instanceof ZipInputStream) {
            closeStream = false;
        } else {
            return null;
        }
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readScans(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/SCANS"), closeStream, chromatogram, monitor);
        this.readPeaks(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/PEAKS"), closeStream, chromatogram, monitor);
        this.readArea(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/AREA"), closeStream, chromatogram, monitor);
        this.readIdentification(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/IDENTIFICATION"), closeStream, chromatogram, monitor);
        this.readHistory(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/HISTORY"), closeStream, chromatogram, monitor);
        this.readMiscellaneous(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CHROMATOGRAM/MISC"), closeStream, chromatogram, monitor);
        this.setAdditionalInformation(file, chromatogram, monitor);
        return chromatogram;
    }

    private IChromatogramOverview readOverviewFromZipFile(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, String.valueOf(directoryPrefix) + "OVERVIEW/TIC");
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readScansOverview(dataInputStream, chromatogram, monitor);
        dataInputStream.close();
        return chromatogram;
    }

    private void readScansOverview(DataInputStream dataInputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            VendorScan massSpectrum = new VendorScan();
            int retentionTime = dataInputStream.readInt();
            float abundance = dataInputStream.readFloat();
            try {
                VendorIon ion = new VendorIon(0.0, abundance);
                massSpectrum.setRetentionTime(retentionTime);
                massSpectrum.addIon((IIon)ion);
                chromatogram.addScan((IScan)massSpectrum);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
    }

    private void setAdditionalInformation(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        int startRetentionTime;
        chromatogram.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
        chromatogram.setFile(file);
        int scanDelay = startRetentionTime = chromatogram.getStartRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int endRetentionTime = chromatogram.getStopRetentionTime();
        int scanInterval = endRetentionTime / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
    }

    private void readScans(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            IVendorScan massSpectrum = this.readMassSpectrum(dataInputStream);
            chromatogram.addScan((IScan)massSpectrum);
            ++scan;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readPeaks(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        int numberOfPeaks = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeaks) {
            try {
                IChromatogramPeakMSD peak = this.readPeak(dataInputStream, chromatogram, monitor);
                chromatogram.addPeak((IPeak)peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private IChromatogramPeakMSD readPeak(DataInputStream dataInputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = this.readString(dataInputStream);
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        IPeakMassSpectrum peakMaximum = this.readPeakMassSpectrum(dataInputStream);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelMSD peakModel = new PeakModelMSD(peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        peak.setDetectorDescription(detectorDescription);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        List<IIntegrationEntry> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        this.readPeakIdentificationTargets(dataInputStream, (IPeakMSD)peak, monitor);
        return peak;
    }

    private List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double ion = dataInputStream.readDouble();
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntry integrationEntry = new IntegrationEntry(ion, integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakMSD peak, IProgressMonitor monitor) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = this.readString(dataInputStream);
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            float matchFactor = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setName(name);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, 0.0f, 0.0f, probability);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                peak.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readArea(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        String integratorDescription = this.readString(dataInputStream);
        List<IIntegrationEntry> chromatogramIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        this.readString(dataInputStream);
        List<IIntegrationEntry> backgroundIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        chromatogram.setIntegratedArea(chromatogramIntegrationEntries, backgroundIntegrationEntries, integratorDescription);
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readIdentification(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        int numberOfTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfTargets) {
            String identifier = this.readString(dataInputStream);
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            float matchFactor = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            ChromatogramLibraryInformation libraryInformation = new ChromatogramLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setName(name);
            ChromatogramComparisonResult comparisonResult = new ChromatogramComparisonResult(matchFactor, reverseMatchFactor, 0.0f, 0.0f, probability);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                chromatogram.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readHistory(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        IEditHistory editHistory = chromatogram.getEditHistory();
        int numberOfEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfEntries) {
            long time = dataInputStream.readLong();
            String description = this.readString(dataInputStream);
            Date date = new Date(time);
            EditInformation editInformation = new EditInformation(date, description);
            editHistory.add((Object)editInformation);
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readMiscellaneous(DataInputStream dataInputStream, boolean closeStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        long time = dataInputStream.readLong();
        String miscInfo = this.readString(dataInputStream);
        String operator = this.readString(dataInputStream);
        Date date = new Date(time);
        chromatogram.setDate(date);
        chromatogram.setMiscInfo(miscInfo);
        chromatogram.setOperator(operator);
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private IVendorScan readMassSpectrum(DataInputStream dataInputStream) throws IOException {
        String massSpectrometer = this.readString(dataInputStream);
        String massSpectrumType = this.readString(dataInputStream);
        VendorScan massSpectrum = new VendorScan();
        massSpectrum.setMassSpectrometer(this.getMassSpectrometerValue(massSpectrometer));
        massSpectrum.setMassSpectrumType(this.getMassSpectrumTypeValue(massSpectrumType));
        int retentionTime = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionIndex(retentionIndex);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                double mz = dataInputStream.readDouble();
                float abundance = dataInputStream.readFloat();
                VendorIon ion = new VendorIon(mz, abundance);
                massSpectrum.addIon((IIon)ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        return massSpectrum;
    }

    private IPeakMassSpectrum readPeakMassSpectrum(DataInputStream dataInputStream) throws IOException {
        String massSpectrometer = this.readString(dataInputStream);
        String massSpectrumType = this.readString(dataInputStream);
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        massSpectrum.setMassSpectrometer(this.getMassSpectrometerValue(massSpectrometer));
        massSpectrum.setMassSpectrumType(this.getMassSpectrumTypeValue(massSpectrumType));
        int retentionTime = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionIndex(retentionIndex);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                double mz = dataInputStream.readDouble();
                float abundance = dataInputStream.readFloat();
                VendorIon ion = new VendorIon(mz, abundance);
                massSpectrum.addIon((IIon)ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        return massSpectrum;
    }

    private short getMassSpectrometerValue(String massSpectrometer) {
        MassSpectrometer detector = MassSpectrometer.valueOf(massSpectrometer);
        int value = 1;
        if (detector == MassSpectrometer.MS2) {
            value = 2;
        } else if (detector == MassSpectrometer.MS3) {
            value = 3;
        }
        return (short)value;
    }

    private short getMassSpectrumTypeValue(String massSpectrumType) {
        MassSpectrumType msType = MassSpectrumType.valueOf(massSpectrumType);
        short value = 0;
        if (msType == MassSpectrumType.PROFILE) {
            value = 1;
        }
        return value;
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("0.7.0.1")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

