/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.CombinedIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.ICombinedIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.ICombinedIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.combined.ICombinedIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.NoIntegratorAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class CombinedIntegratorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Combined Chromatogram and Peak Integrator";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            ICombinedIntegratorSupport support = CombinedIntegrator.getCombinedIntegratorSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableIntegratorIds()) {
                ICombinedIntegratorSupplier supplier = support.getIntegratorSupplier(processorId);
                list.add((IProcessSupplier<?>)new CombinedIntegratorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIntegratorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class CombinedIntegratorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<ICombinedIntegrationSettings> {
        public CombinedIntegratorProcessorSupplier(ICombinedIntegratorSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getIntegratorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.WSD, DataType.CSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, ICombinedIntegrationSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings instanceof ICombinedIntegrationSettings) {
                messageConsumer.addMessages((MessageProvider)CombinedIntegrator.integrate(chromatogramSelection, processSettings, this.getId(), monitor));
            } else {
                messageConsumer.addMessages((MessageProvider)CombinedIntegrator.integrate(chromatogramSelection, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

