/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IBaselineSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.ISettingStatus;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.ISegment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.Segment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.SegmentAreaCalculator;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.support.IntegrationConstraint;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.IonPercentages;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIntegrator {
    private static final String DESCRIPTION = "Integrator Trapezoid";
    private static final double CORRECTION_FACTOR_TRAPEZOID = 100.0;

    public IPeakIntegrationResult integrate(IPeak peak, PeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeak(peak);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        boolean includeBackground = peakIntegrationSettings.isIncludeBackground();
        PeakIntegrationResult result = null;
        IBaselineSupport baselineSupport = peakIntegrationSettings.getBaselineSupport();
        List<IIntegrationEntry> integrationEntries = this.calculateIntegratedArea(peak, baselineSupport, peakIntegrationSettings.getSelectedIons(), includeBackground);
        peak.setIntegratedArea(integrationEntries, DESCRIPTION);
        ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus(peak);
        if (settingStatus.report()) {
            double integratedArea = this.calculateIntegratedArea(integrationEntries);
            result = this.getPeakIntegrationResult(peak, integratedArea, (IPeakIntegrationSettings)peakIntegrationSettings);
        }
        return result;
    }

    public IPeakIntegrationResults integrate(List<? extends IPeak> peaks, PeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeakList(peaks);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        IPeakIntegrationResult peakIntegrationSumResult = null;
        PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
        int peakNumber = 1;
        for (IPeak iPeak : peaks) {
            IPeakIntegrationResult peakIntegrationResult;
            monitor.subTask("Integrate Peak " + peakNumber++);
            try {
                peakIntegrationResult = this.integrate(iPeak, peakIntegrationSettings, monitor);
            }
            catch (ValueMustNotBeNullException e) {
                continue;
            }
            ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus(iPeak);
            if (!settingStatus.report()) continue;
            if (settingStatus.sumOn()) {
                if (peakIntegrationSumResult == null) {
                    peakIntegrationSumResult = peakIntegrationResult;
                    this.resetIntegrationSumResultValues(peakIntegrationSumResult);
                    continue;
                }
                peakIntegrationSumResult.setStopRetentionTime(peakIntegrationResult.getStopRetentionTime());
                double integratedArea = peakIntegrationSumResult.getIntegratedArea() + peakIntegrationResult.getIntegratedArea();
                peakIntegrationSumResult.setIntegratedArea(integratedArea);
                continue;
            }
            if (peakIntegrationSumResult != null) {
                peakIntegrationResults.add(peakIntegrationSumResult);
                peakIntegrationSumResult = null;
            }
            peakIntegrationResults.add(peakIntegrationResult);
        }
        if (peakIntegrationSumResult != null) {
            peakIntegrationResults.add(peakIntegrationSumResult);
            peakIntegrationSumResult = null;
        }
        return peakIntegrationResults;
    }

    private void validatePeakList(List<? extends IPeak> peaks) throws ValueMustNotBeNullException {
        if (peaks == null) {
            throw new ValueMustNotBeNullException("The peak list must not be null.");
        }
    }

    private void validatePeak(IPeak peak) throws ValueMustNotBeNullException {
        IPeakWSD peakWSD;
        IPeakCSD peakFID;
        IPeakMSD peakMSD;
        if (peak == null) {
            throw new ValueMustNotBeNullException("The peak instance must not be null.");
        }
        if (peak instanceof IPeakMSD ? (peakMSD = (IPeakMSD)peak).getPeakModel() == null : (peak instanceof IPeakCSD ? (peakFID = (IPeakCSD)peak).getPeakModel() == null : peak instanceof IPeakWSD && (peakWSD = (IPeakWSD)peak).getPeakModel() == null)) {
            throw new ValueMustNotBeNullException("The peak model must not be null.");
        }
    }

    private void validateSettings(IIntegrationSettings integrationSettings) throws ValueMustNotBeNullException {
        if (integrationSettings == null) {
            throw new ValueMustNotBeNullException("The integration settings must not be null.");
        }
    }

    private List<IIntegrationEntry> calculateIntegratedArea(IPeak peak, IBaselineSupport baselineSupport, IMarkedIons selectedIons, boolean includeBackground) {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        if (peak instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)peak;
            IPeakModelMSD peakModel = peakMSD.getPeakModel();
            IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
            double integratedAreaTIC = this.calculateTICPeakArea(peak, baselineSupport, includeBackground);
            if (selectedIons.size() > 0 && !selectedIons.getIonsNominal().contains(AbstractIon.getIon((double)0.0))) {
                Set ions = selectedIons.getIonsNominal();
                IonPercentages ionPercentages = new IonPercentages((IScanMSD)massSpectrum);
                for (Integer ion : ions) {
                    float correctionFactor = ionPercentages.getPercentage(ion.intValue()) / 100.0f;
                    double integratedArea = integratedAreaTIC * (double)correctionFactor;
                    IntegrationEntry integrationEntry = new IntegrationEntry((double)ion.intValue(), integratedArea);
                    integrationEntries.add((IIntegrationEntry)integrationEntry);
                }
            } else {
                IntegrationEntry integrationEntry = new IntegrationEntry(0.0, integratedAreaTIC);
                integrationEntries.add((IIntegrationEntry)integrationEntry);
            }
        } else if (peak instanceof IPeakCSD) {
            double integratedAreaTIC = this.calculateTICPeakArea(peak, baselineSupport, includeBackground);
            IntegrationEntry integrationEntry = new IntegrationEntry(integratedAreaTIC);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
        } else if (peak instanceof IPeakWSD) {
            double integratedAreaTIC = this.calculateTICPeakArea(peak, baselineSupport, includeBackground);
            IntegrationEntry integrationEntry = new IntegrationEntry(integratedAreaTIC);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
        }
        return integrationEntries;
    }

    private double calculateTICPeakArea(IPeak peak, IBaselineSupport baselineSupport, boolean includeBackground) {
        List retentionTimes;
        IPeakModelMSD peakModel;
        double integratedArea = 0.0;
        if (peak instanceof IPeakMSD) {
            peakModel = ((IPeakMSD)peak).getPeakModel();
            retentionTimes = peakModel.getRetentionTimes();
        } else if (peak instanceof IPeakCSD) {
            peakModel = ((IPeakCSD)peak).getPeakModel();
            retentionTimes = peakModel.getRetentionTimes();
        } else if (peak instanceof IPeakWSD) {
            peakModel = ((IPeakWSD)peak).getPeakModel();
            retentionTimes = peakModel.getRetentionTimes();
        } else {
            return integratedArea;
        }
        int i = 0;
        while (i < retentionTimes.size() - 1) {
            int startRetentionTime = (Integer)retentionTimes.get(i);
            int stopRetentionTime = (Integer)retentionTimes.get(i + 1) - 1;
            float peakAbundanceStart = peakModel.getPeakAbundance(startRetentionTime);
            float peakAbundanceStop = peakModel.getPeakAbundance(stopRetentionTime);
            integratedArea += this.calculatePeakArea(peak, startRetentionTime, stopRetentionTime, peakAbundanceStart, peakAbundanceStop);
            if (includeBackground) {
                integratedArea += this.calculateBaselineCorrectedPeakArea(peak, baselineSupport, startRetentionTime, stopRetentionTime);
            }
            ++i;
        }
        if (integratedArea < 1.0) {
            integratedArea = 0.0;
        }
        return integratedArea;
    }

    private double calculatePeakArea(IPeak peak, int startRetentionTime, int stopRetentionTime, float peakAbundanceStart, float peakAbundanceStop) {
        double integratedArea = 0.0;
        Point psp1 = new Point((double)startRetentionTime, (double)peakAbundanceStart);
        Point psp2 = new Point((double)stopRetentionTime, (double)peakAbundanceStop);
        Point pbp1 = new Point((double)startRetentionTime, 0.0);
        Point pbp2 = new Point((double)stopRetentionTime, 0.0);
        Segment segment = new Segment((IPoint)pbp1, (IPoint)pbp2, (IPoint)psp1, (IPoint)psp2);
        integratedArea = SegmentAreaCalculator.calculateSegmentArea((ISegment)segment) / 100.0;
        return integratedArea;
    }

    private double calculateBaselineCorrectedPeakArea(IPeak peak, IBaselineSupport baselineSupport, int startRetentionTime, int stopRetentionTime) {
        IPeakModelMSD peakModel;
        double integratedArea = 0.0;
        if (peak instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)peak;
            peakModel = peakMSD.getPeakModel();
        } else if (peak instanceof IPeakCSD) {
            IPeakCSD peakFID = (IPeakCSD)peak;
            peakModel = peakFID.getPeakModel();
        } else {
            return integratedArea;
        }
        float chromatogramBaselineStart = 0.0f;
        float chromatogramBaselineStop = 0.0f;
        if (!peak.getIntegrationConstraints().hasIntegrationConstraint(IntegrationConstraint.LEAVE_PEAK_AS_IT_IS)) {
            chromatogramBaselineStart = this.validateChromatogramBaseline((IPeakModel)peakModel, baselineSupport, startRetentionTime);
            chromatogramBaselineStop = this.validateChromatogramBaseline((IPeakModel)peakModel, baselineSupport, stopRetentionTime);
            Point cbp1 = new Point((double)startRetentionTime, (double)chromatogramBaselineStart);
            Point cbp2 = new Point((double)stopRetentionTime, (double)chromatogramBaselineStop);
            Point pbp1 = new Point((double)startRetentionTime, (double)peakModel.getBackgroundAbundance(startRetentionTime));
            Point pbp2 = new Point((double)stopRetentionTime, (double)peakModel.getBackgroundAbundance(stopRetentionTime));
            Segment segment = new Segment((IPoint)cbp1, (IPoint)cbp2, (IPoint)pbp1, (IPoint)pbp2);
            integratedArea = SegmentAreaCalculator.calculateSegmentArea((ISegment)segment) / 100.0;
        }
        return integratedArea;
    }

    private float validateChromatogramBaseline(IPeakModel peakModel, IBaselineSupport baselineSupport, int retentionTime) {
        float totalPeakHeight = 0.0f;
        float chromatogramBaseline = 0.0f;
        totalPeakHeight = peakModel.getBackgroundAbundance(retentionTime) + peakModel.getPeakAbundance(retentionTime);
        chromatogramBaseline = baselineSupport.getBackgroundAbundance(retentionTime);
        if (chromatogramBaseline > totalPeakHeight) {
            chromatogramBaseline = totalPeakHeight;
        }
        return chromatogramBaseline;
    }

    private PeakIntegrationResult getPeakIntegrationResult(IPeak peak, double integratedArea, IPeakIntegrationSettings peakIntegrationSettings) {
        IChromatogramPeakMSD chromatogramPeak;
        IMarkedIons selectedIons = peakIntegrationSettings.getSelectedIons();
        Set<Integer> integratedIons = this.getIntegratedIons(selectedIons);
        PeakIntegrationResult result = new PeakIntegrationResult();
        result.setIntegratedArea(integratedArea);
        result.setIntegratorType(DESCRIPTION);
        result.setPeakType(peak.getPeakType().toString());
        if (peak instanceof IChromatogramPeakMSD) {
            chromatogramPeak = (IChromatogramPeakMSD)peak;
            result.setPurity(chromatogramPeak.getPurity());
            result.setSN(chromatogramPeak.getSignalToNoiseRatio());
        } else if (peak instanceof IChromatogramPeakCSD) {
            chromatogramPeak = (IChromatogramPeakCSD)peak;
            result.setSN(chromatogramPeak.getSignalToNoiseRatio());
        }
        if (peak instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)peak;
            result.setStartRetentionTime(peakMSD.getPeakModel().getStartRetentionTime());
            result.setStopRetentionTime(peakMSD.getPeakModel().getStopRetentionTime());
            result.setTailing(peakMSD.getPeakModel().getTailing());
            result.setWidth(peakMSD.getPeakModel().getWidthByInflectionPoints());
            result.addIntegratedIons(integratedIons);
        } else if (peak instanceof IPeakCSD) {
            IPeakCSD peakFID = (IPeakCSD)peak;
            result.setStartRetentionTime(peakFID.getPeakModel().getStartRetentionTime());
            result.setStopRetentionTime(peakFID.getPeakModel().getStopRetentionTime());
            result.setTailing(peakFID.getPeakModel().getTailing());
            result.setWidth(peakFID.getPeakModel().getWidthByInflectionPoints());
        }
        return result;
    }

    private void resetIntegrationSumResultValues(IPeakIntegrationResult peakIntegrationSumResult) {
        peakIntegrationSumResult.setPeakType("Summed integrated area");
        peakIntegrationSumResult.setPurity(0.0f);
        peakIntegrationSumResult.setSN(0.0f);
        peakIntegrationSumResult.setTailing(0.0f);
        peakIntegrationSumResult.setWidth(0);
    }

    private Set<Integer> getIntegratedIons(IMarkedIons selectedIons) {
        HashSet<Integer> result = selectedIons == null ? new HashSet<Integer>() : selectedIons.getIonsNominal();
        return result;
    }

    private double calculateIntegratedArea(List<? extends IIntegrationEntry> integrationEntries) {
        double result = 0.0;
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            result += iIntegrationEntry.getIntegratedArea();
        }
        return result;
    }
}

