/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.IPeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.PeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.AbstractPeakFilter;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.FilterSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.PeakFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakFilter
extends AbstractPeakFilter {
    private static final String DESCRIPTION = "SNIP Filter Peak(s) Mass Spectra";

    public IProcessingInfo<IPeakFilterResult> applyFilter(List<IPeakMSD> peaks, IPeakFilterSettings filterSettings, IProgressMonitor monitor) {
        PeakFilterSettings peakFilterSettings = filterSettings instanceof PeakFilterSettings ? (PeakFilterSettings)filterSettings : PreferenceSupplier.getPeakFilterSettings();
        FilterSupplier filterSupplier = new FilterSupplier();
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        for (IPeakMSD peakMSD : peaks) {
            massSpectra.add((IScanMSD)peakMSD.getPeakModel().getPeakMassSpectrum());
        }
        int iterations = peakFilterSettings.getIterations();
        int transitions = peakFilterSettings.getTransitions();
        double magnificationFactor = peakFilterSettings.getMagnificationFactor();
        filterSupplier.applySnipFilter(massSpectra, iterations, transitions, magnificationFactor, monitor);
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        PeakFilterResult peakFilterResult = new PeakFilterResult(ResultStatus.OK, "The SNIP filter has been applied successfully.");
        processingInfo.setProcessingResult((Object)peakFilterResult);
        return processingInfo;
    }
}

