/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.ChromatogramCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculatorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.exceptions.NoChromatogramCalculatorSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.settings.IChromatogramCalculatorSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramCalculatorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Calculator";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        try {
            IChromatogramCalculatorSupport support = ChromatogramCalculator.getChromatogramCalculatorSupport();
            for (String processorId : support.getAvailableCalculatorIds()) {
                IChromatogramCalculatorSupplier supplier = support.getCalculatorSupplier(processorId);
                list.add((IProcessSupplier<?>)new ChromatogramCalculatorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoChromatogramCalculatorSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramCalculatorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramCalculatorSettings> {
        public ChromatogramCalculatorProcessorSupplier(IChromatogramCalculatorSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getCalculatorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD, DataType.WSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramCalculatorSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings == null) {
                messageConsumer.addMessages((MessageProvider)ChromatogramCalculator.applyCalculator(chromatogramSelection, this.getId(), monitor));
            } else {
                messageConsumer.addMessages((MessageProvider)ChromatogramCalculator.applyCalculator(chromatogramSelection, processSettings, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

